<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/analytics/data/v1alpha/analytics_data_api.proto

namespace Google\Analytics\Data\V1alpha;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * An audience list is a list of users in an audience at the time of the list's
 * creation. One audience may have multiple audience lists created for different
 * days.
 *
 * Generated from protobuf message <code>google.analytics.data.v1alpha.AudienceList</code>
 */
class AudienceList extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. Identifier. The audience list resource name assigned during
     * creation. This resource name identifies this `AudienceList`.
     * Format: `properties/{property}/audienceLists/{audience_list}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $name = '';
    /**
     * Required. The audience resource name. This resource name identifies the
     * audience being listed and is shared between the Analytics Data & Admin
     * APIs.
     * Format: `properties/{property}/audiences/{audience}`
     *
     * Generated from protobuf field <code>string audience = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $audience = '';
    /**
     * Output only. The descriptive display name for this audience. For example,
     * "Purchasers".
     *
     * Generated from protobuf field <code>string audience_display_name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $audience_display_name = '';
    /**
     * Required. The dimensions requested and displayed in the query response.
     *
     * Generated from protobuf field <code>repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $dimensions;
    /**
     * Output only. The current state for this AudienceList.
     *
     * Generated from protobuf field <code>optional .google.analytics.data.v1alpha.AudienceList.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $state = null;
    /**
     * Output only. The time when CreateAudienceList was called and the
     * AudienceList began the `CREATING` state.
     *
     * Generated from protobuf field <code>optional .google.protobuf.Timestamp begin_creating_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $begin_creating_time = null;
    /**
     * Output only. The total quota tokens charged during creation of the
     * AudienceList. Because this token count is based on activity from the
     * `CREATING` state, this tokens charged will be fixed once an AudienceList
     * enters the `ACTIVE` or `FAILED` states.
     *
     * Generated from protobuf field <code>int32 creation_quota_tokens_charged = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $creation_quota_tokens_charged = 0;
    /**
     * Output only. The total number of rows in the AudienceList result.
     *
     * Generated from protobuf field <code>optional int32 row_count = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $row_count = null;
    /**
     * Output only. Error message is populated when an audience list fails during
     * creation. A common reason for such a failure is quota exhaustion.
     *
     * Generated from protobuf field <code>optional string error_message = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $error_message = null;
    /**
     * Output only. The percentage completed for this audience export ranging
     * between 0 to 100.
     *
     * Generated from protobuf field <code>optional double percentage_completed = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $percentage_completed = null;
    /**
     * Output only. The recurring audience list that created this audience list.
     * Recurring audience lists create audience lists daily.
     * If audience lists are created directly, they will have no associated
     * recurring audience list, and this field will be blank.
     *
     * Generated from protobuf field <code>optional string recurring_audience_list = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $recurring_audience_list = null;
    /**
     * Optional. Configures webhook notifications to be sent from the Google
     * Analytics Data API to your webhook server. Use of webhooks is optional. If
     * unused, you'll need to poll this API to determine when an audience list is
     * ready to be used. Webhooks allow a notification to be sent to your servers
     * & avoid the need for polling.
     * Either one or two POST requests will be sent to the webhook. The first POST
     * request will be sent immediately showing the newly created audience list in
     * its CREATING state. The second POST request will be sent after the audience
     * list completes creation (either the ACTIVE or FAILED state).
     * If identical audience lists are requested in quick succession, the second &
     * subsequent audience lists can be served from cache. In that case, the
     * audience list create method can return an audience list is already ACTIVE.
     * In this scenario, only one POST request will be sent to the webhook.
     *
     * Generated from protobuf field <code>optional .google.analytics.data.v1alpha.WebhookNotification webhook_notification = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $webhook_notification = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Output only. Identifier. The audience list resource name assigned during
     *           creation. This resource name identifies this `AudienceList`.
     *           Format: `properties/{property}/audienceLists/{audience_list}`
     *     @type string $audience
     *           Required. The audience resource name. This resource name identifies the
     *           audience being listed and is shared between the Analytics Data & Admin
     *           APIs.
     *           Format: `properties/{property}/audiences/{audience}`
     *     @type string $audience_display_name
     *           Output only. The descriptive display name for this audience. For example,
     *           "Purchasers".
     *     @type array<\Google\Analytics\Data\V1alpha\AudienceDimension>|\Google\Protobuf\Internal\RepeatedField $dimensions
     *           Required. The dimensions requested and displayed in the query response.
     *     @type int $state
     *           Output only. The current state for this AudienceList.
     *     @type \Google\Protobuf\Timestamp $begin_creating_time
     *           Output only. The time when CreateAudienceList was called and the
     *           AudienceList began the `CREATING` state.
     *     @type int $creation_quota_tokens_charged
     *           Output only. The total quota tokens charged during creation of the
     *           AudienceList. Because this token count is based on activity from the
     *           `CREATING` state, this tokens charged will be fixed once an AudienceList
     *           enters the `ACTIVE` or `FAILED` states.
     *     @type int $row_count
     *           Output only. The total number of rows in the AudienceList result.
     *     @type string $error_message
     *           Output only. Error message is populated when an audience list fails during
     *           creation. A common reason for such a failure is quota exhaustion.
     *     @type float $percentage_completed
     *           Output only. The percentage completed for this audience export ranging
     *           between 0 to 100.
     *     @type string $recurring_audience_list
     *           Output only. The recurring audience list that created this audience list.
     *           Recurring audience lists create audience lists daily.
     *           If audience lists are created directly, they will have no associated
     *           recurring audience list, and this field will be blank.
     *     @type \Google\Analytics\Data\V1alpha\WebhookNotification $webhook_notification
     *           Optional. Configures webhook notifications to be sent from the Google
     *           Analytics Data API to your webhook server. Use of webhooks is optional. If
     *           unused, you'll need to poll this API to determine when an audience list is
     *           ready to be used. Webhooks allow a notification to be sent to your servers
     *           & avoid the need for polling.
     *           Either one or two POST requests will be sent to the webhook. The first POST
     *           request will be sent immediately showing the newly created audience list in
     *           its CREATING state. The second POST request will be sent after the audience
     *           list completes creation (either the ACTIVE or FAILED state).
     *           If identical audience lists are requested in quick succession, the second &
     *           subsequent audience lists can be served from cache. In that case, the
     *           audience list create method can return an audience list is already ACTIVE.
     *           In this scenario, only one POST request will be sent to the webhook.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Analytics\Data\V1Alpha\AnalyticsDataApi::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. Identifier. The audience list resource name assigned during
     * creation. This resource name identifies this `AudienceList`.
     * Format: `properties/{property}/audienceLists/{audience_list}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Output only. Identifier. The audience list resource name assigned during
     * creation. This resource name identifies this `AudienceList`.
     * Format: `properties/{property}/audienceLists/{audience_list}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. The audience resource name. This resource name identifies the
     * audience being listed and is shared between the Analytics Data & Admin
     * APIs.
     * Format: `properties/{property}/audiences/{audience}`
     *
     * Generated from protobuf field <code>string audience = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getAudience()
    {
        return $this->audience;
    }

    /**
     * Required. The audience resource name. This resource name identifies the
     * audience being listed and is shared between the Analytics Data & Admin
     * APIs.
     * Format: `properties/{property}/audiences/{audience}`
     *
     * Generated from protobuf field <code>string audience = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setAudience($var)
    {
        GPBUtil::checkString($var, True);
        $this->audience = $var;

        return $this;
    }

    /**
     * Output only. The descriptive display name for this audience. For example,
     * "Purchasers".
     *
     * Generated from protobuf field <code>string audience_display_name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getAudienceDisplayName()
    {
        return $this->audience_display_name;
    }

    /**
     * Output only. The descriptive display name for this audience. For example,
     * "Purchasers".
     *
     * Generated from protobuf field <code>string audience_display_name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setAudienceDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->audience_display_name = $var;

        return $this;
    }

    /**
     * Required. The dimensions requested and displayed in the query response.
     *
     * Generated from protobuf field <code>repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getDimensions()
    {
        return $this->dimensions;
    }

    /**
     * Required. The dimensions requested and displayed in the query response.
     *
     * Generated from protobuf field <code>repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param array<\Google\Analytics\Data\V1alpha\AudienceDimension>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setDimensions($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Analytics\Data\V1alpha\AudienceDimension::class);
        $this->dimensions = $arr;

        return $this;
    }

    /**
     * Output only. The current state for this AudienceList.
     *
     * Generated from protobuf field <code>optional .google.analytics.data.v1alpha.AudienceList.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return isset($this->state) ? $this->state : 0;
    }

    public function hasState()
    {
        return isset($this->state);
    }

    public function clearState()
    {
        unset($this->state);
    }

    /**
     * Output only. The current state for this AudienceList.
     *
     * Generated from protobuf field <code>optional .google.analytics.data.v1alpha.AudienceList.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Analytics\Data\V1alpha\AudienceList\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Output only. The time when CreateAudienceList was called and the
     * AudienceList began the `CREATING` state.
     *
     * Generated from protobuf field <code>optional .google.protobuf.Timestamp begin_creating_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getBeginCreatingTime()
    {
        return $this->begin_creating_time;
    }

    public function hasBeginCreatingTime()
    {
        return isset($this->begin_creating_time);
    }

    public function clearBeginCreatingTime()
    {
        unset($this->begin_creating_time);
    }

    /**
     * Output only. The time when CreateAudienceList was called and the
     * AudienceList began the `CREATING` state.
     *
     * Generated from protobuf field <code>optional .google.protobuf.Timestamp begin_creating_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setBeginCreatingTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->begin_creating_time = $var;

        return $this;
    }

    /**
     * Output only. The total quota tokens charged during creation of the
     * AudienceList. Because this token count is based on activity from the
     * `CREATING` state, this tokens charged will be fixed once an AudienceList
     * enters the `ACTIVE` or `FAILED` states.
     *
     * Generated from protobuf field <code>int32 creation_quota_tokens_charged = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getCreationQuotaTokensCharged()
    {
        return $this->creation_quota_tokens_charged;
    }

    /**
     * Output only. The total quota tokens charged during creation of the
     * AudienceList. Because this token count is based on activity from the
     * `CREATING` state, this tokens charged will be fixed once an AudienceList
     * enters the `ACTIVE` or `FAILED` states.
     *
     * Generated from protobuf field <code>int32 creation_quota_tokens_charged = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setCreationQuotaTokensCharged($var)
    {
        GPBUtil::checkInt32($var);
        $this->creation_quota_tokens_charged = $var;

        return $this;
    }

    /**
     * Output only. The total number of rows in the AudienceList result.
     *
     * Generated from protobuf field <code>optional int32 row_count = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getRowCount()
    {
        return isset($this->row_count) ? $this->row_count : 0;
    }

    public function hasRowCount()
    {
        return isset($this->row_count);
    }

    public function clearRowCount()
    {
        unset($this->row_count);
    }

    /**
     * Output only. The total number of rows in the AudienceList result.
     *
     * Generated from protobuf field <code>optional int32 row_count = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setRowCount($var)
    {
        GPBUtil::checkInt32($var);
        $this->row_count = $var;

        return $this;
    }

    /**
     * Output only. Error message is populated when an audience list fails during
     * creation. A common reason for such a failure is quota exhaustion.
     *
     * Generated from protobuf field <code>optional string error_message = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getErrorMessage()
    {
        return isset($this->error_message) ? $this->error_message : '';
    }

    public function hasErrorMessage()
    {
        return isset($this->error_message);
    }

    public function clearErrorMessage()
    {
        unset($this->error_message);
    }

    /**
     * Output only. Error message is populated when an audience list fails during
     * creation. A common reason for such a failure is quota exhaustion.
     *
     * Generated from protobuf field <code>optional string error_message = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setErrorMessage($var)
    {
        GPBUtil::checkString($var, True);
        $this->error_message = $var;

        return $this;
    }

    /**
     * Output only. The percentage completed for this audience export ranging
     * between 0 to 100.
     *
     * Generated from protobuf field <code>optional double percentage_completed = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return float
     */
    public function getPercentageCompleted()
    {
        return isset($this->percentage_completed) ? $this->percentage_completed : 0.0;
    }

    public function hasPercentageCompleted()
    {
        return isset($this->percentage_completed);
    }

    public function clearPercentageCompleted()
    {
        unset($this->percentage_completed);
    }

    /**
     * Output only. The percentage completed for this audience export ranging
     * between 0 to 100.
     *
     * Generated from protobuf field <code>optional double percentage_completed = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param float $var
     * @return $this
     */
    public function setPercentageCompleted($var)
    {
        GPBUtil::checkDouble($var);
        $this->percentage_completed = $var;

        return $this;
    }

    /**
     * Output only. The recurring audience list that created this audience list.
     * Recurring audience lists create audience lists daily.
     * If audience lists are created directly, they will have no associated
     * recurring audience list, and this field will be blank.
     *
     * Generated from protobuf field <code>optional string recurring_audience_list = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getRecurringAudienceList()
    {
        return isset($this->recurring_audience_list) ? $this->recurring_audience_list : '';
    }

    public function hasRecurringAudienceList()
    {
        return isset($this->recurring_audience_list);
    }

    public function clearRecurringAudienceList()
    {
        unset($this->recurring_audience_list);
    }

    /**
     * Output only. The recurring audience list that created this audience list.
     * Recurring audience lists create audience lists daily.
     * If audience lists are created directly, they will have no associated
     * recurring audience list, and this field will be blank.
     *
     * Generated from protobuf field <code>optional string recurring_audience_list = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setRecurringAudienceList($var)
    {
        GPBUtil::checkString($var, True);
        $this->recurring_audience_list = $var;

        return $this;
    }

    /**
     * Optional. Configures webhook notifications to be sent from the Google
     * Analytics Data API to your webhook server. Use of webhooks is optional. If
     * unused, you'll need to poll this API to determine when an audience list is
     * ready to be used. Webhooks allow a notification to be sent to your servers
     * & avoid the need for polling.
     * Either one or two POST requests will be sent to the webhook. The first POST
     * request will be sent immediately showing the newly created audience list in
     * its CREATING state. The second POST request will be sent after the audience
     * list completes creation (either the ACTIVE or FAILED state).
     * If identical audience lists are requested in quick succession, the second &
     * subsequent audience lists can be served from cache. In that case, the
     * audience list create method can return an audience list is already ACTIVE.
     * In this scenario, only one POST request will be sent to the webhook.
     *
     * Generated from protobuf field <code>optional .google.analytics.data.v1alpha.WebhookNotification webhook_notification = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Analytics\Data\V1alpha\WebhookNotification|null
     */
    public function getWebhookNotification()
    {
        return $this->webhook_notification;
    }

    public function hasWebhookNotification()
    {
        return isset($this->webhook_notification);
    }

    public function clearWebhookNotification()
    {
        unset($this->webhook_notification);
    }

    /**
     * Optional. Configures webhook notifications to be sent from the Google
     * Analytics Data API to your webhook server. Use of webhooks is optional. If
     * unused, you'll need to poll this API to determine when an audience list is
     * ready to be used. Webhooks allow a notification to be sent to your servers
     * & avoid the need for polling.
     * Either one or two POST requests will be sent to the webhook. The first POST
     * request will be sent immediately showing the newly created audience list in
     * its CREATING state. The second POST request will be sent after the audience
     * list completes creation (either the ACTIVE or FAILED state).
     * If identical audience lists are requested in quick succession, the second &
     * subsequent audience lists can be served from cache. In that case, the
     * audience list create method can return an audience list is already ACTIVE.
     * In this scenario, only one POST request will be sent to the webhook.
     *
     * Generated from protobuf field <code>optional .google.analytics.data.v1alpha.WebhookNotification webhook_notification = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Analytics\Data\V1alpha\WebhookNotification $var
     * @return $this
     */
    public function setWebhookNotification($var)
    {
        GPBUtil::checkMessage($var, \Google\Analytics\Data\V1alpha\WebhookNotification::class);
        $this->webhook_notification = $var;

        return $this;
    }

}

