<?php

use App\Http\Controllers\ProfileController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\CompanyController;
use App\Http\Controllers\CompanyUserController;
use App\Http\Controllers\PurchaseController;
use App\Http\Controllers\SystemAdminDashboardController;
use Illuminate\Foundation\Application;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Artisan;

use Inertia\Inertia;

/*
|----------------------------------------------------------------------
| Web Routes
|----------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return Inertia::render('Welcome', [
        'canLogin' => Route::has('login'),
        'canRegister' => false,
    ]);
});


// System Admin Access routes

Route::middleware(['auth:web', 'verified', 'check.role:system_admin'])->group(function () {
    Route::resource('companies', CompanyController::class);
    Route::get('/system-company-users', [SystemAdminDashboardController::class, 'getCompanyUsers'])->name('system.company.users');
    Route::get('/company-profiles', [SystemAdminDashboardController::class, 'showCompanyProfiles'])->name('system.company.show');
    Route::get('/system-admin/reports', [SystemAdminDashboardController::class, 'Reports'])->name('system-admin.reports.index');
    Route::get('/system-admin/top-companies', [SystemAdminDashboardController::class, 'TopCompanyReports'])->name('system-admin.top-companies');
    Route::get('/system-admin/companies/show', [SystemAdminDashboardController::class, 'getDateRange'])->name('system-admin.companies.show');
            
    Route::get('/dashboard', function () {
        return Inertia::render('SystemAdmin/Dashboard', [
            'canLogin' => Route::has('login'),
            'canRegister' => true,
            'userRole' => auth()->user()->role,
        ]);
    })->name('dashboard');
});




//=== Admin and user

Route::middleware(['auth:admin,user', 'verified', 'role.redirect'])->group(function () {
    Route::get('/userdashboard', function () {
        return Inertia::render('Company/UserDashboard', [
            'userRole' => auth()->user()->role,
        ]);
    })->name('userdashboard');

    $pages = [
        // Only admin access to these routes
        'view-profile' => 'Company/profile/ViewProfile',
        'add_profiles' => 'Company/profile/AddProfiles',
        'admin_users' => 'Company/Users/Admin_Users',
        'categories' => 'Company/Product/Category',
        'medicine-type' => 'Company/Product/MedicineType',
        'products' => 'Company/Product/Products',
        'product-barcode' => 'Company/Product/ProductBarcode',
        'all-barcodes' => 'Company/Product/AllBarcodes',
        'stocks' => 'Company/Stocks',
        'suppliers' => 'Company/Supplier/Suppliers',
        'supplier-payment' => 'Company/Supplier/SupplierPayment',
        'purchases' => 'Company/Purchase/Purchases',
        'expense' => 'Company/Expense',
        'basic-reports' => 'Company/Reports/BasicReports',
        'advanced-reports' => 'Company/Reports/AdvancedReports',
        'reversal-action' => 'Company/Sales/ReversalActions',
        'approved-reversals' => 'Company/Sales/ApprovedReversalLogs',

        // Both admin and user access
        'sales' => 'Company/Sales/Sales',
        'partial-customers' => 'Company/Sales/PartialCustomers',
        'checkout-sale' => 'Company/Checkout',
        'reverse-sales' => 'Company/Sales/ReverseSales',
        'reversal-logs' => 'Company/Sales/ReversalLogs',
        'today-reports' => 'Company/Reports/TodayReports',
        'user-profile' => 'Company/Users/UserProfile',
    ];

    foreach ($pages as $route => $component) {
        // Allow both admin and purchase_person for these two
        if (in_array($route, ['stocks', 'purchases'])) {
            Route::get("/userdashboard/{$route}", function () use ($component) {
                return Inertia::render($component, [
                    'userRole' => auth()->user()->role,
                ]);
            })->middleware('role:admin,purchase_person')->name("userdashboard.{$route}");

        // Admin-only routes
        } elseif (in_array($route, ['view-profile', 'add_profiles', 'admin_users', 'categories',
                                    'medicine-type', 'products','product-barcode','all-barcodes',
                                    'suppliers', 'supplier-payment',
                                    'basic-reports', 'advanced-reports', 'expense', 'reversal-action',
                                    'approved-reversals'])) {
            Route::get("/userdashboard/{$route}", function () use ($component) {
                return Inertia::render($component, [
                    'userRole' => auth()->user()->role,
                ]);
            })->middleware('role:admin')->name("userdashboard.{$route}");

        // Routes for both admin and user (including sales_person, etc.)
        } else {
            Route::get("/userdashboard/{$route}", function () use ($component) {
                return Inertia::render($component, [
                    'userRole' => auth()->user()->role,
                ]);
            })->name("userdashboard.{$route}");
        }
    }
});



// ====  Route of check-out summary after clicking on checkout in card of sales

Route::get('/checkout-summary', [PurchaseController::class, 'showCheck'])->name('checkout.summary');




Route::middleware('multi_guard_auth', 'auth:web,admin,user')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});




Route::get('/seeder', function () {
    Artisan::call('db:seed', ['--class' => 'AdminUserSeeder']);
    return 'Seeder executed! 
            name => Host,
            email => seeder@gmail.com,
            password => seeder2002,
            role => system_admin';
});

require __DIR__.'/auth.php';
