<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\UserController;
use App\Http\Controllers\CompanyController;
use App\Http\Controllers\CompanyProfileController;
use App\Http\Controllers\CompanyUserController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\MedicineTypeController;
use App\Http\Controllers\SupplierController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\PurchaseController;
use App\Http\Controllers\StockController;
use App\Http\Controllers\ProductSupplierController;
use App\Http\Controllers\SaleItemController;
use App\Http\Controllers\ExpenseController;
use App\Http\Controllers\ReversalController;
use App\Models\Purchase;
use App\Models\Sale;
use App\Models\Stock;
use App\Models\Supplier;

// System Admin Routes

Route::apiResource('users', UserController::class);
Route::get('comp-count', [SystemAdminDashboardController::class, 'CompanyCount']);
Route::get('all_user-count', [SystemAdminDashboardController::class, 'AllCompanyUserCount']);
Route::get('total-transactions', [SystemAdminDashboardController::class, 'TotalTransactions']);
Route::get('all-expired', [SystemAdminDashboardController::class, 'getAllExpiredProducts']);
Route::get('system-active-user-count', [SystemAdminDashboardController::class, 'getSystemActiveUserCount']);
Route::get('system-company-profiles', [SystemAdminDashboardController::class, 'getCompanyProfiles']);
Route::get('system-company-users', [SystemAdminDashboardController::class, 'getCompanyUsers']);
Route::get('/system-barchart-month-sales', [SystemAdminDashboardController::class, 'getSystemChartMonthSales']);
Route::post('/full-system-backup', [SystemAdminDashboardController::class, 'getSystemCompanies']);







// Company
Route::apiResource('companies', CompanyController::class)->names('api.companies');

// CompanyUser
Route::apiResource('company-users', CompanyUserController::class)->names('api.company-users');
Route::get('user-count', [CompanyUserController::class, 'CompanyUserCount']);
Route::get('active-user-count', [CompanyUserController::class, 'getActiveUserCount']);
Route::get('users-list', [CompanyUserController::class, 'getUsersList']);
Route::get('active-users', [CompanyUserController::class, 'getActiveUsers']);
Route::get('get-user-profile', [CompanyUserController::class, 'getUserProfile']);
Route::post('/update-user-profile', [CompanyUserController::class, 'updateUserProfile']);

// Category
Route::apiResource('/categories', CategoryController::class);
Route::get('category-count', [CategoryController::class, 'CategoryCount']);
Route::get('categories/show', [CategoryController::class, 'show']);


// Medicine Type
Route::apiResource('medicine-types', MedicineTypeController::class);
Route::get('/medicine-types/show', [MedicineTypeController::class, 'show']);
Route::get('/medicine-type-count', [MedicineTypeController::class, 'MedicineTypeCount']);



// Company Profile
Route::apiResource('company-profiles', CompanyProfileController::class);
Route::get('top-company', [CompanyProfileController::class, 'TopCompanies']);
Route::put('/company-profiles/{id}', [CompanyProfileController::class, 'update']);


// Supplier
Route::apiResource('suppliers', SupplierController::class);
Route::post('/store-payments', [SupplierController::class, 'StorePayment']);
Route::get('/show-payments/{supplierId}', [SupplierController::class, 'ShowPayment']);
Route::get('/get-supplier-data', [SupplierController::class, 'getSupplierData']);


// Purchase
Route::apiResource('purchases', PurchaseController::class);
Route::get('purchased-count', [PurchaseController::class, 'countPurchasedProducts']);
Route::post('/purchase/checkout', [PurchaseController::class, 'Checkout'])->name('purchase.checkout');



// Stock
Route::apiResource('stocks', StockController::class);
Route::get('get-stock-data', [StockController::class, 'getStockData']);
Route::get('/stock-history/{id}', [StockController::class, 'history']);

Route::get('stocked-count', [StockController::class, 'countStockedProducts']);
Route::post('/update-stock', [StockController::class, 'updateStock']);
Route::get('/search-drug', [StockController::class, 'searchDrug']);
Route::get('/drug-details/{id}', [StockController::class, 'getDrugDetails']);
Route::get('/low-stocks', [StockController::class, 'getLowStocks']);
Route::get('/high-stocks', [StockController::class, 'getHighStocks']);


// Reports
Route::get('/five-best-sales', [SaleController::class, 'TopFiveSales']);
Route::get('/current-month-sales', [SaleController::class, 'CurrentMonthSales']);
Route::get('/all-sales', [SaleController::class, 'allSales']);
Route::get('/all-product-sales', [SaleController::class, 'allProductSales']);
Route::get('/all-current-month-sales', [SaleController::class, 'allCurrentMonthSales']);
Route::get('/barchart-month-sales', [SaleController::class, 'getChartMonthSales']);
Route::get('/recent-sales', [SaleController::class, 'getRecentSales']);


// today
Route::get('/today-sales', [SaleController::class, 'TodaySales']);
Route::get('/total-today-sales', [SaleController::class, 'TotalTodaySales']);
Route::get('/circle-line-today-sales', [SaleController::class, 'getCircleLineTodaySales']);
Route::get('/barchart-today-sales', [SaleController::class, 'getBarchartTodaySales']);


// Product Supplier
Route::apiResource('product-suppliers', ProductSupplierController::class);


// Products
Route::apiResource('products', ProductController::class);
Route::get('product-count', [ProductController::class, 'countAllProducts']);
Route::get('expire-count', [ProductController::class, 'countExpiredProducts']);
Route::get('/expired', [ProductController::class, 'getExpiredProducts']);
Route::get('/near-expired', [ProductController::class, 'getNearExpiredProducts']);
Route::get('/out-of-stock-products', [ProductController::class, 'OutOfStockProducts']);
Route::get('/get-product-data', [ProductController::class, 'getProductData']);


// Sales
Route::apiResource('sales', SaleController::class);
Route::get('/bill', [SaleController::class, 'PrintBill'])->name('bill');
Route::get('/partial-customers', [SaleController::class, 'PartialCustomers']);
Route::put('/pay-customer/{id}', [SaleController::class, 'updatePayment']);
Route::get('/partial-customers-list', [SaleController::class, 'PartialCustomersList']);
Route::get('/walk-in-customers-list', [SaleController::class, 'WalkInCustomersList']);
Route::get('/partial-customers/{id}/products', [SaleController::class, 'getProductsByPartialCustomerId']);
Route::get('/customers/{customerName}/payments', [SaleController::class, 'getCustomerPayments']);

// SaleItem
Route::get('/sale-items', [SaleItemController::class, 'index']);
Route::post('/sale-items/filter', [SaleItemController::class, 'filterSales']);




// System Settings
Route::get('/system-settings', [SystemSettingController::class, 'index']);
Route::post('/system-settings', [SystemSettingController::class, 'update']);
Route::post('/db-backup', [SystemSettingController::class, 'backupCompanies']);




// Expense
Route::apiResource('expenses', ExpenseController::class);








// Reversal Logs
Route::post('/reverse-sale', [ReversalController::class, 'store']);
Route::get('/pending-reversals', [ReversalController::class, 'showPending']);
Route::post('/approve-reversal/{id}', [ReversalController::class, 'approveReversal']);
Route::get('/reversal-logs', [ReversalController::class, 'reversalLogs']);
Route::get('/all-reversal-logs', [ReversalController::class, 'allReversalLogs']);






/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/



Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});
