import { createI18n } from 'vue-i18n';

const messages = {
  en: {
    pashto: 'Pashto',
    //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ System Admin Part
    // Dashboard page
    total_companies: 'Total Companies',
    total_users: 'Total Users',
    active_users: 'Active Users',
    total_transactions: 'Total Transactions',

    // Dashboard Layout
    dashboard_layout: "Dashboard Layout",
    dashboard: "Dashboard",
    companies: "Companies",
    company_profiles: "Company Profiles",
    company_users: "Company Users",
    data_reports: "Data Reports",
    top_companies: "Top Companies",
    profile_layout: "Profile",
    logout: "Logout",

     // Common translations
    name: "Name",
    email: "Email",
    actions: "Actions",
    update: "Update",
    cancel: "Cancel",
    yes: "Yes",
    no: "No",
    dashboard: "Dashboard",
    status: "Status",
    lock: "Lock",
    unlock: "Unlock",
    page: "Page",
    of: "of",
   
    // Company Management
    manage_companies: "Manage Companies",
    company_management: "Company Management",
    new_company: "New Company",
    search_placeholder: "Search by name or email...",
    update_company: "Update Company",
    new_password: "New Password",
    confirm_password: "Confirm Password",
    confirm_delete: "Confirm Delete",
    delete_confirmation: "Are you sure you want to delete this company?",
   
    // Company Profiles
    profiles: "Profiles",
    company_profiles: "Company Profiles",
    search_company_placeholder: "Search company by name and address",
    logo: "Logo",
    company_name: "Company Name",
    address: "Address",
    phone_number: "Phone Number",
    website: "Website",
    about: "About",
    no_company: "No Company!",

    // Company Users
    company_users: 'Company Users',
    dashboard: 'Dashboard',
    search_placeholder: 'Search user by name, email or company',
    all_companies: 'All Companies',
    loading: 'Loading...',
    profile_image: 'Profile Image',
    user_name: 'User Name',
    email: 'Email',
    address: 'Address',
    phone_number: 'Phone Number',
    company_name: 'Company Name',
    last_seen: 'Last Seen',
    no_address: 'No Address',
    no_phone: 'No Phone',
    never: 'Never',
    no_users_found: 'No users found',
    page: 'Page',
    of: 'of',
    user_image: 'User Image',



    // Reports page
    reports_title: "Reports Of Companies's Data For System Admin",
    reports_description: "Comprehensive overview of system performance and analytics.",
    filters: {
      date_range: "Date Range",
      start_date: "Start Date",
      end_date: "End Date",
      company: "Company",
      all_companies: "All Companies",
      generate_report: "Generate Report"
    },
    date_range_options: {
      today: "Today",
      yesterday: "Yesterday",
      this_week: "This Week",
      last_week: "Last Week",
      this_month: "This Month",
      last_month: "Last Month",
      this_year: "This Year",
      last_year: "Last Year",
      custom: "Custom Range"
    },
    summary_cards: {
      total_sales: "Total Sales",
      total_profit: "Total Profit",
      items_sold: "Items Sold",
      avg_sale_value: "Avg. Sale Value"
    },
    sections: {
      sales_by_company: "Sales by Company",
      stock_status: "Stock Status",
      top_selling_products: "Top Selling Products",
      low_stock_alerts: "Low Stock Alerts",
      out_of_stock_items: "Products Added (No Stock Yet)",
      recent_purchases: "Recent Purchases"
    },
    table_headers: {
      company: "Company",
      total_sales: "Total Sales",
      total_profit: "Total Profit",
      transactions: "Transactions",
      product: "Product",
      quantity_sold: "Quantity Sold",
      total_revenue: "Total Revenue"
    },
    status_labels: {
      low_stock: "Low Stock",
      out_of_stock: "Out Of Stock",
      high_stock: "High Stock"
    },
    no_data: {
      sales_data: "No sales data available for the selected period",
      top_products: "No top selling products data available",
      low_stock: "No low stock items",
      out_of_stock: "No out of stock items",
      recent_purchases: "No recent purchases"
    },
    units: {
      items: "items",
      units: "units",
      each: "each"
    },


    // Top Companies
    topCompaniesTitle: "Top Companies ✨",
    topCompaniesDescription: "Analyze and compare company performance based on different metrics",

    filterMetric: "Metric",
    filterTimeRange: "Time Range",
    filterShowTop: "Show Top",

    metricRevenue: "Revenue",
    metricSales: "Sales",
    metricProducts: "Products",
    metricUsers: "Users",

    timeRangeWeekly: "Weekly",
    timeRangeMonthly: "Monthly",
    timeRangeQuarterly: "Quarterly",
    timeRangeYearly: "Yearly",

    statTopCompany: "Top Company ({metric})",
    statTotal: "Total {metric}",
    statAverage: "Average {metric}",
    statTimeRange: "Time Range",
    statAcrossCompanies: "Across {count} companies",
    statPerCompany: "Per company",
    statCurrentFilter: "Current filter",

    chartTitle: "{metric} Comparison",
    chartNoData: "No data available for chart",

    companyListTitle: "Top {limit} Companies by {metric} ({timeRange})",
    companyListNoResults: "No companies found matching your criteria",


    // Profile page
    profile: {
      title: "Profile Information",
      description: "Update your account's profile information and email address",
      name: "Name",
      email: "Email",
      unverified: "Your email address is unverified.",
      resend_verification: "Click here to re-send the verification email.",
      verification_sent: "A new verification link has been sent to your email address.",
      saved_success: "Saved successfully"
    },
    password_update: {
      title: "Update Password",
      description: "Ensure your account is using a long, random password to stay secure",
      current: "Current Password",
      new: "New Password",
      confirm: "Confirm Password",
      updated: "Password updated",
      label: "Password"
    },
    acountDelete: {
      title: "Delete Account",
      description: "Permanently remove your account and all of its data",
      warning: "Once your account is deleted, all of its resources and data will be permanently deleted. Please download any data before deleting.",
      button: "Delete Account",
      modal_title: "Delete Account",
      modal_text: "Are you sure you want to delete your account? This action cannot be undone."
    },
    common: {
      save: "Save Changes",
      saving: "Saving...",
      update: "Update Password",
      updating: "Updating...",
      delete: "Delete Account",
      deleting: "Deleting...",
      cancel: "Cancel"
    },






    //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ Company Part
    // User Dashboard page
    welcome: 'Welcome',
    logged_in_as: 'You are logged in as',
    today_sales: "Today's Sales",
    current_month_sale: 'Current Month Sales',
    total_sale: 'Total Sales',
    total_today_sale: "Today's Profits",
    profit_current_month: 'Profit current month',
    total_profit_made: 'Total Profit Made',
    expired_products: 'Expired Products',
    user_added: 'Users Added',
    active_users: 'Active Users',
    category_added: 'Categories Added',
    medicine_type_added: 'Medicine Types',
    product_added: 'Product Added',
    purchase_added: 'Purchases',
    stock_added: 'Stock Products',
    low_stock_items: 'Low Stock Items',
    high_stock_items: 'High Stock Items',
    motivation: {
      empoweringPharmacies: "Empowering pharmacies with intelligent solutions.",
      connectingPatients: "Connecting patients to better healthcare.",
      revolutionizingDelivery: "Revolutionizing the way medicine is delivered.",
      healthMission: "Your health, our mission.",
      healthPriority: "Your health, our priority.",
      innovatingCare: "Innovating care for every community.",
      trustedHealthcare: "Trusted healthcare, one step ahead.",
      futureOfPharmacy: "Shaping the future of pharmacy services.",
      qualityMedicines: "Delivering quality medicines with care.",
      safeHealing: "Safe healing, seamless experience."
    },


    // ‌Bill.vue page

    invoice: 'Invoice',
    thankYou: 'Thank you for your purchase!',
    customerDetails: 'Customer Details',
    name: 'Name',
    saleDate: 'Date of Sale',
    amountPaid: 'Amount Paid',
    orderDetails: 'Order Details',
    productName: 'Product Name',
    price: 'Price',
    quantity: 'Quantity',
    total: 'Total',
    grandTotal: 'Grand Total',
    goBack: 'Go Back',
    printBill: 'Print Bill',
    "invoiceNumber": "Invoice No.",
    paid: 'Paid',


    // ViewProfile.vue page
    try:'Health is a great wealth!',
    company_address: 'Address:',
    company_email: 'Email:',
    company_phone: 'Phone:',
    company_website: 'Website:',
    about_company: 'About Us:',
    update_profile: 'Update Profile',
    add_profile: 'Add Profile',
    system_settings: 'System Settings',
    app_currency: 'App Currency',
    app_language: 'App Language',
    save_settings: 'Save',
    get_backup: 'Get Backup',
    afghani: 'Afghani',
    dollar: 'Dollar',
    english: 'English',
    farsi: 'Farsi',
    user_role: 'Role',


    // Add or Update Profile
    choose_logo: 'Choose Logo',
    company_name: 'Company Name',


    // UserDashboardLayout.vue 
    dashboard: 'Dashboard', 
    add: 'Add', 
    users: '● Users', 
    category: '● Category', 
    suppliers: '● Suppliers', 
    products: 'Products', 
    purchases: 'Purchases', 
    stocks: 'Stocks', 
    sales: 'Sales', 
    sale_reports: 'Sale Reports', 
    today_reports: '● Today Reports', 
    basic_reports: '● Basic Reports', 
    adv_reports: '● Adv. Reports', 
    sale_reversals: 'Sale Reversals', 
    add_reversals: '● Add Reversals', 
    reversal_logs: '● Reversal Logs', 
    expense: 'Expense', 
    company_profile: 'Profile', 
    user_profile: 'User Profile',
    reversal_action: '● Reversal Action',
    approved_reversal: '● Approved Rev..',
    drug_type: '● Drug Type',


    // Company Users
    dashboard_add_user: 'Dashboard > Add User',
    add_new_user: 'Add New User',
    user_search_place: 'Search user by name/email...',
    register_new_user: ' Register New User',
    user_id: 'ID',
    user_name: 'User Name',
    user_email: ' Email',
    user_image: 'Image',
    user_phone: 'Phone',
    user_register_date: 'Register Date',
    user_edit: ' Edit',
    user_delete: 'Delete',
    no_user_added: 'No User Added!',
    update_user: 'Update User',
    user_name: 'User Name',
    user_email: 'Email',
    update: 'Update',
    cancel: 'Cancel',
    confirm_delete: 'Confirm Delete',
    confirm_message: 'Are you sure you want to delete this user? ',
    yes: 'Yes',
    no: 'No',
    search_user: 'Search user by name/email',
    page: 'Page',
    of: 'of',



    // Company Category
    dashboard_add_category: 'Dashboard > Add Category',
    add_new_category: 'Add New Category',
    category_search_place: 'Search user by name/description...',
    register_new_category: ' Register New Category',
    loading: 'Loading...',
    pdf: 'PDF',
    category_id: 'ID',
    category_name: 'Category Name',
    category_description: 'Description',
    category_edit: ' Edit',
    category_delete: 'Delete',
    add_category: 'Add Category',
    update_category: 'Update Category',
    search_category: 'Search category by name/description',
    no_category: 'No Category Yet!',
    enter_category_name: 'Enter category name',
    enter_category_desc : 'Enter category description',



    // Medicine Type page
    add_medicine_type: 'Add Medicine Type',
    dashboard_add_type: 'Dashboard > Add Medicine Type',
    search_type: 'Search medicine type by name and abr...',
    add_new_type: 'Add New Type',
    type_id: 'Type ID',
    type_name: 'Type Name',
    abreviation: 'Abbreviation',
    desc: 'Description',
    action: 'Actions',
    update_type: 'Update Type',
    medicine_type: 'Medicine Type',
    select_medicine_type: 'Select Medicine Type',
    no_stock_yet: 'No Stock Exists!',
    enter_type_name: 'Enter Type Name',
    enter_abreviation: 'Enter Abreviation',
    enter_desc: 'Enter Description',


    // Expense page
    expense_management: 'Expense Management',
    dashboard_expense: 'Dashboard > Expense',
    search_expense: 'Search Expense By Expense Type..',
    amount: 'Amount',
    expense_type: 'Expense Type',
    expense_date: 'Date',
    edit_expense: 'Edit Expense',
    add_new_expense: 'Add New Expense',
    update_expense: 'Update Expense',
    add_expense: 'Add Expense',



    // AuthenticatedLayout.vue page
    auth_profile: 'Profile',
    auth_logout: 'Logout',
    expired_product: 'Expired Products',
    close: 'Close',
    expired: 'Expired',
    near_expired: 'Near-to-Expired Products',
    no_near_expired: 'No product Near to Expired!',
    no_expired_yet: 'No Expired Product yet!',
    out_of_stock: 'Out of Stock Products',
    expiration_date: 'Expiration Date',
    confirm_backup: 'Confirm Backup',
    confirm_backup_message: 'Are you sure to get backup?',
    backup_path: 'Backup Path : ',
    no_user_yet: 'No User Yet!',
    no_active_user_yet: 'No Active User Yet!',
    user_activity: 'User Activity',
    active_users: 'Active Users',
    profile_image: 'Profile Image',
    user_address: 'Address',
    user_reg_date: 'Register Date',
    user_last_seen: 'Last Seen',
    stock_status_amount: 'Stock Status Amount (Low Stock)',




    // Guest Layout page
    welcome_back: 'Welcome Back!',
    login_or_register_based_on_rule: 'Log in or Register new company or user to continue to your dashboard based on your role.',
    remember_me: 'Remember me',
    forgot_password: 'Forgot your password?',
    password: 'Password',


    // Register page
    "register": "Register",
    "name": "Name",
    "email": "Email",
    "password": "Password",
    "confirm_password": "Confirm Password",
    "role": "Role",
    "select_role": "Select a role",
    "sale_person": "Sale Person",
    "purchase_person": "Purchase Person",
    "already_registered": "Already registered?",


    // Today Sales Log
    today_sales_log: 'Sales Log For Today',
    profit: 'Profit',
    sale_date: 'Sale Date',
    total_today_sales_log: 'Total Sales Log For Today',
    total_sales: 'Total Sales',
    total_transaction: 'Total Transaction',
    total_quantity: 'Total Quantity',
    total_profit: 'Total Profit',
    circle_graph: 'Circular (Pie) Graph of Daily Sales',
    bar_chart: 'Bar Chart of Daily Sales',
    line_graph: 'Graph (Line) of Daily Sales',



    // Basic Sales Log
    basic_circle_graph: 'Circular (Pie) Graph of Yearly Sales',
    basic_bar_chart: 'Bar Chart of Yearly Sales',
    basic_line_graph: 'Graph (Line) of Yearly Sales',
    recent_sales: 'Recent Sales',
    top_five_best_products: 'Top Five Best Selling Products',
    current_month_sales: 'ُTotal of Current Month Sales',
    total_sales: 'Total of All Sales',
    total_sales_details: 'All Sales Products (detailed)',
    current_month_sales_details: 'Current Month Sales (detailed)',



    // Advanced Reports
    filter: 'Filter',
    from: 'From Date',
    to: 'To Date',
    no_product_in_date: 'No Product in this date!',
    all: 'All',
    payment_status: 'Payment Status',
    fully_paid: 'Fully Paid',
    partial_paid: 'Partial Payment',
    reset: 'Reset',




    // Suppliers.vue 
    dashboard_add_supplier: 'Dashboard > Add Supplier ',
    add_new_supplier: 'Add Supplier',
    supplier_search_place: 'Search supplier by name',
    register_new_supplier: 'Add New Supplier',
    supplier_phone: 'Phone',
    supplier_name: 'Supplier Name',
    supplier_address: 'Address ',
    supplier_email: 'Email ',
    supplier_join_date: 'Join Date',
    supplier_total_money: 'Total Money',
    supplier_recieve_money: 'Recieved Money',
    supplier_remain_money: 'Remain Money',
    actions: 'Action',
    supplier_payment: 'Payment',
    supplier_edit: 'Edit',
    supplier_delete: 'Delete',
    no_supplier: 'No Supplier Yet!',
    contact_person: 'Contact Person',
    update_supplier: 'Update Supplier',
    make_payment: 'Make Payment',
    payment_amount: 'Payment Amount',
    payment_date: 'Payment Date',
    payment_history: 'Payment History',
    payment_number: 'Payment Number',
    search_supplier: 'Search Supplier By Name..',
    no_payment: 'No Payment Yet!',


    // Products.vue page
    add_product: "Add Product",
    dashboard: "Dashboard",
    search_placeholder: "Search products by name...",
    barcodes: "Barcodes",
    pdf: "PDF",
    upload_excel: "UPLOAD WITH EXCEL",
    add_new_product: "Add New Product",
    product_id: "Product ID",
    product_image: "Product Image",
    max_size: 'Max size',
    product_name: "Product Name",
    stock_amount: "Stock Amount",
    stock_status: "Stock Status",
    purchase_price: "Purchase Price",
    sale_price: "Sale Price",
    manufacturing_date: "Manufacturing Date",
    expiry_date: 'Expiration Date',
    barcode_number: 'Barcode Number',
    quantity: "Quantity",
    expiry: "Expiry",
    days: "Days",
    action: "Action",
    no_product: "No Product Yet!",
    edit: 'Edit',
    delete: 'Delete',
    barcode: 'Barcode',
    product_category: 'Product Category',
    select_category: 'Select a category',
    update_product: 'Update Product',
    no_date: 'No date',
    expired: 'Expired',
    active: 'Active',
    no_day: 'No Day',
    all_categories: "All Categories",
    all_medicine_types: "All Medicine Types",
    show_expired_only: "Show Expired Only",
    show_active_only: "Show Active Only",

    // ‌BarcodePage
    barcode_page: 'Barcode Page',
    print_barcode: 'Print Barcode',
    all_barcode: 'All products barcodes',


    // Purchases.vue page
    add_purchase: 'Add Purchase',
    dashboard_add_purchase: 'Dashboard > Add Purchase',
    search_purchase: 'Search by product or supplier name..',
    total_amount: 'Total Amount',
    purchase_date: 'Purchase Date',
    no_purchase: 'No Purchase Yet!',
    unit_price: 'Unit Price',
    update_purchase: 'Update Purchase',

    // Stocks.vue
    add_stock: 'Add Stock',
    dashboard_add_stock: 'Dashboard > Add Stock',
    search_stock: 'Search stock by product name',
    "modal_purchase": {
      "purchaseHistoryFor": "Purchase History for"
    },
    "table_purchase": {
      "supplier": "Supplier",
      "purchasePrice": "Purchase Price",
      "quantity": "Quantity",
      "purchaseDate": "Purchase Date",
      "noHistoryFound": "No purchase history found for this product."
    },


    // Sales.vue page
    search_drug: 'Search drug by name',
    available: 'available',
    add_to_card: 'Add to Card',
    empty_card: 'Your card is empty',
    remove: 'Remove',
    total_price: 'Total Price',
    checkout: 'Checkout',
    final_process: 'Final Processing Stage',
    customer_details: 'Customer Details',
    customer_name: 'Customer Name',
    date_of_sale: 'Date of Sale',
    pay_now: 'Pay Now',
    amount_paid: 'Amount Paid',
    order_details: 'Order Details',
    no_product_display: 'No product to display',
    enter_customer_name: 'Enter customer name here',
    enter_amount_paid: 'Enter amount paid here',
    remaining: 'Remaining',
    type: 'Type',



    // Partial Customers
    "customers": "Customers",
    "search_customer": "Search by customer name..",
    "tables": {
      "index": "#",
      "customer_name": "Customer Name",
      "total_amount": "Total Amount",
      "amount_paid": "Amount Paid",
      "remain": "Remain",
      "action": "Action",
      "details": "Details",
      "pay": "Pay"
    },
    "pagination": {
      "prev": "Prev",
      "next": "Next"
    },
    "payment_form": {
      "title": "Payment Form",
      "customer_name": "Customer Name",
      "total_amount": "Total Amount",
      "amount_to_pay": "Amount to Pay",
      "submit": "Submit Payment"
    },
    "partial_customers": "Partial Customers",
    "walkin_customers": "Walk-in Customers",
    "customer_name": "Customer Name",
    "total_amount": "Total Amount",
    "amount_paid": "Amount Paid",
    "remain": "Remain",
    "sale_date": "Sale Date",
    "details": "Details",
    "products": "Products",
    "paids": "Paids",
    "prev": "Prev",
    "next": "Next",
    "page": "Page",
    "of": "of",
    "products_for": "Products for",
    "sale_date": "Sale Date",
    "image": "Image",
    "product_name": "Product Name",
    "price": "Price",
    "quantity": "Quantity",
    "total": "Total",
    "close": "Close",
    "modal": {
      "productsFor": "Products for",
      "paymentsFor": "Payments for",
      "phone": "Phone",
      "email": "Email"
    },
    "table": {
      "image": "Image",
      "productName": "Product Name",
      "price": "Price",
      "quantity": "Quantity",
      "total": "Total",
      "saleId": "Sale ID",
      "totalAmount": "Total Amount",
      "amountPaid": "Amount Paid",
      "paymentDate": "Payment Date"
    },
    "summary": {
      "totalAmount": "Total Amount",
      "totalPaid": "Total Paid",
      "remaining": "Remaining"
    },
    "buttons": {
      "close": "Close"
    },






    // add reversal
    reverse_sale: 'Reverse Sales',
    dashboard_reverse_sale: 'Dashboard > Reverse Sales',
    reverse: 'Reverse',
    no_sale_to_reverse: 'No sale to be reverse!',
    enter_reason: 'Enter reason for reversal',
    reversal_log: 'Reversal Logs',
    dashboard_reversal_log: 'Dashboard > Reversal Logs',
    search_reversal_log: 'Search reversal log',
    users_id: 'User ID',
    reverse_date: 'Reverse Date',
    reason: 'Reason',
    status: 'Status',
    no_reversal_log: 'No reversal sale yet!',


    // Reversal Action
    reverse_action: 'Reverse Actions',
    dashboard_reverse_action: 'Dashboard > Reverse Actions',
    search_reverse_action: 'Search sold product to reverse',
    no_sale_to_approve: 'No product to be approved!',
    confirm_approve: 'Approve confirm',
    approve_message: 'Are you sure to approve?',
    approve: 'Approve',


    // Approved reversal
    approved_reversals: 'Approved Reversals',
    dashboard_approved: 'Dashboard > Approved Reversals',
    search_approved: 'Search approved sales',
    no_approved: 'No product approved!',



    // Checkout Summary page
    "customer_type": "Customer Type",
    "walk_in_customer": "Walk-in-customer",
    "partial": "Partial",
    "select_customer": "Select Customer",
    "no_existing_customer": "-- No Existing Customer --",
    "phone_number": "Phone Number",
    "phone_number_placeholder":"Phone number",
    "email_placeholder": "Email address",
    "address_placeholder": "Address or location",



    // Welcome header
    home: 'Home',
    topCompanies: 'Top Companies',
    searchDrugs: 'Search Drugs',
    features: 'Features',
    ourServices: 'Our Services',
    contactUs: 'Contact Us',
    dashboard: 'Dashboard',
    login: 'Log in',

    //===========    Welcome page ========
      // Home Section
  "homeTitle": "Your Health, Our Priority",
  "homeSubtitle": "Empowering healthier communities with quality pharmaceutical care.",
  "seeDrugs": "See Drugs",
  "learnMore": "Learn More",

  // Top Companies Section
  "topCompaniesTitle": "Trusted Pharmaceutical Companies",
  "topCompaniesSubtitle": "Explore our top partner companies offering reliable, high-quality pharmaceutical products.",

  // // Search Drugs Section
  // "searchDrugsTitle": "Find Medications Quickly & Reliably",
  // "searchDrugsPlaceholder": "Type a drug name...",

  // // Features Section
  // "featuresTitle": "Why Choose Us",
  // "featuresSubtitle": "Our platform is designed to streamline your pharmacy management experience with ease of use and cutting-edge features.",

  // // Services Section
  // "servicesTitle": "Comprehensive Pharmacy Solutions",
  // "servicesSubtitle": "From managing inventory to ensuring efficient service, we provide a full range of solutions for your pharmacy.",

  // // Contact Section
  // "contactTitle": "Get in Touch with Us",
  // "contactSubtitle": "We’d love to hear from you! Whether you have questions or feedback, reach out today.",
  // "contactNamePlaceholder": "Your Name",
  // "contactEmailPlaceholder": "Your Email",
  // "contactMessagePlaceholder": "Your Message",
  // "contactSubmitButton": "Submit",

  // Footer
  "footerContact": "Contact us: (+93(77)7566648) | (ghafoorsultani2002@gmail.com)",


  "companyAddress": "Address",
  "companyPhone": "Phone",
  "companyEmail": "Email",
  "companyWebsite": "Website",
  "companyAbout": "About",
  "company": "Company",
  "address": "Address",
  "email": "Email",
  "phone": "Phone",
  "about": "About",
  "website": "Website",



    "featuresTitle": "Our Features",
  "featuresSubtitle": "Everything you need to manage your inventory efficiently",
  "featureCards": {
    "inventory": "📦 Real-Time Inventory Management",
    "inventoryDesc": "Monitor stock levels, set automatic restocking alerts, and avoid shortages.",
    "order": "🛒 Seamless Order Processing",
    "orderDesc": "Place orders instantly and track shipments with real-time updates.",
    "security": "🔐 Secure & Compliant System",
    "securityDesc": "Ensure regulatory compliance with encrypted data storage and user authentication.",
    "reporting": "📊 Advanced Reporting",
    "reportingDesc": "Generate detailed reports on sales, inventory, and customer behavior.",
    "mobile": "📱 Mobile Accessibility",
    "mobileDesc": "Access your inventory and place orders from anywhere using our mobile app.",
    "integration": "🌐 Multi-Channel Integration",
    "integrationDesc": "Integrate with multiple sales channels for a unified inventory management experience."
  },
  "servicesTitle": "Our Services",
  "servicesSubtitle": "Comprehensive solutions tailored to your business needs",
  "serviceCards": {
    "analytics": "📊 Business Analytics",
    "analyticsDesc": "Gain insights into sales trends, stock movement, and customer behavior.",
    "customer": "👥 Customer Management",
    "customerDesc": "Track customer orders, preferences, and communication history.",
    "restocking": "🔄 Automated Restocking",
    "restockingDesc": "Receive smart recommendations and automatic order placements.",
    "forecasting": "📈 Sales Forecasting",
    "forecastingDesc": "Predict future sales trends and plan inventory accordingly.",
    "warehouse": "📦 Warehouse Optimization",
    "warehouseDesc": "Optimize warehouse layout and operations for maximum efficiency.",
    "customReports": "📝 Custom Reporting",
    "customReportsDesc": "Create custom reports tailored to your business needs."
  },
  "contactTitle": "Contact Us",
  "contactCards": {
    "phone": "Contact Number",
    "phoneValue": "+93 77756648",
    "email": "Email Address",
    "emailValue": "ghafoorsultani2002@gmail.com",
    "website": "Website",
    "websiteValue": "ghafoorsultani.me"
  },
  "contactForm": {
    "namePlaceholder": "Enter your name",
    "emailPlaceholder": "Enter your email",
    "messagePlaceholder": "Enter your message",
    "submitButton": "Send Message"
  },



  "footer": {
    "about": {
      "title": "About",
      "description": "I like working with new tools and technologies.",
      "socialLinks": "Social Links"
    },
    "quickLinks": {
      "title": "Quick Links",
      "home": "Home",
      "companies": "Top Companies",
      "search": "Search Drugs",
      "features": "Features",
      "services": "Services",
      "contact": "Contact Us"
    },
    "contact": {
      "title": "Have a Question?",
      "phone": "+93 777566648",
      "email": "ghafoorsultani2002@gmail.com"
    },
    "copyright": "© {year} Unified Pharmacy System. All rights reserved."
  },

  },
  //========================================================================
  fa: {

    pashto: 'پشتو',
    //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ System Admin Part
     // Dashboard page
    total_companies: 'شرکت های کل',
    total_users: 'کاربران کل',
    active_users: 'کاربران فعال',
    total_transactions: 'تراکنش های کل',

    // Dashboard Layout
    dashboard_layout: "طرح داشبورد",
    dashboard: "داشبورد",
    companies: "شرکت ها",
    company_profiles: "پروفایل شرکت ها",
    company_users: "کاربران شرکت",
    data_reports: "گزارشات داده",
    top_companies: "شرکت های برتر",
    profile_layout: "پروفایل",
    logout: "خروج",


    // Common translations
    name: "نام",
    email: "ایمیل",
    actions: "عملیات",
    update: "بروزرسانی",
    cancel: "انصراف",
    yes: "بله",
    no: "خیر",
    dashboard: "داشبورد",
    status: "وضعیت",
    lock: "قفل",
    unlock: "باز کردن",
    page: "صفحه",
    of: "از",
   
    // Company Management
    manage_companies: "مدیریت شرکت‌ها",
    company_management: "مدیریت شرکت‌ها",
    new_company: "شرکت جدید",
    search_placeholder: "جستجو بر اساس نام یا ایمیل...",
    update_company: "بروزرسانی شرکت",
    new_password: "رمز عبور جدید",
    confirm_password: "تکرار رمز عبور",
    confirm_delete: "تایید حذف",
    delete_confirmation: "آیا مطمئن هستید که می‌خواهید این شرکت را حذف کنید؟",
   
    // Company Profiles
    profiles: "پروفایل‌ها",
    company_profiles: "پروفایل شرکت‌ها",
    search_company_placeholder: "جستجوی شرکت بر اساس نام و آدرس",
    logo: "لوگو",
    company_name: "نام شرکت",
    address: "آدرس",
    phone_number: "شماره تلفن",
    website: "وبسایت",
    about: "درباره",
    no_company: "شرکتی وجود ندارد!",


    // Company Users
    company_users: 'کاربران شرکت',
    dashboard: 'داشبورد',
    search_placeholder: 'جستجو بر اساس نام، ایمیل یا شرکت',
    all_companies: 'همه شرکت‌ها',
    loading: 'در حال بارگذاری...',
    profile_image: 'تصویر پروفایل',
    user_name: 'نام کاربر',
    email: 'ایمیل',
    address: 'آدرس',
    phone_number: 'شماره تلفن',
    company_name: 'نام شرکت',
    last_seen: 'آخرین بازدید',
    no_address: 'بدون آدرس',
    no_phone: 'بدون تلفن',
    never: 'هرگز',
    no_users_found: 'کاربری یافت نشد',
    page: 'صفحه',
    of: 'از',
    user_image: 'تصویر کاربر',

    
    // Reports
    reports_title: "گزارشات اطلاعات شرکت‌ها برای مدیر سیستم",
    reports_description: "نمای کلی جامع از عملکرد و تحلیل‌های سیستم",
    filters: {
      date_range: "بازه زمانی",
      start_date: "تاریخ شروع",
      end_date: "تاریخ پایان",
      company: "شرکت",
      all_companies: "همه شرکت‌ها",
      generate_report: "تولید گزارش"
    },
    date_range_options: {
      today: "امروز",
      yesterday: "دیروز",
      this_week: "این هفته",
      last_week: "هفته گذشته",
      this_month: "این ماه",
      last_month: "ماه گذشته",
      this_year: "امسال",
      last_year: "سال گذشته",
      custom: "بازه سفارشی"
    },
    summary_cards: {
      total_sales: "فروش کل",
      total_profit: "سود کل",
      items_sold: "تعداد فروش",
      avg_sale_value: "میانگین ارزش فروش"
    },
    sections: {
      sales_by_company: "فروش بر اساس شرکت",
      stock_status: "وضعیت موجودی",
      top_selling_products: "پرفروش‌ترین محصولات",
      low_stock_alerts: "هشدارهای موجودی کم",
      out_of_stock_items: "محصولات اضافه شده (بدون موجودی)",
      recent_purchases: "خریدهای اخیر"
    },
    table_headers: {
      company: "شرکت",
      total_sales: "فروش کل",
      total_profit: "سود کل",
      transactions: "تراکنش‌ها",
      product: "محصول",
      quantity_sold: "تعداد فروخته شده",
      total_revenue: "درآمد کل"
    },
    status_labels: {
      low_stock: "موجودی کم",
      out_of_stock: "ناموجود",
      high_stock: "موجودی زیاد"
    },
    no_data: {
      sales_data: "هیچ داده فروشی برای بازه زمانی انتخاب شده موجود نیست",
      top_products: "داده‌ای برای محصولات پرفروش موجود نیست",
      low_stock: "هیچ آیتمی با موجودی کم وجود ندارد",
      out_of_stock: "هیچ آیتم ناموجودی وجود ندارد",
      recent_purchases: "خرید اخیری وجود ندارد"
    },
    units: {
      items: "آیتم",
      units: "عدد",
      each: "به ازای هر"
    },



    // Top Companies
    topCompaniesTitle: "شرکت های برتر ✨",
    topCompaniesDescription: "تحلیل و مقایسه عملکرد شرکت‌ها بر اساس معیارهای مختلف",

    filterMetric: "معیار",
    filterTimeRange: "بازه زمانی",
    filterShowTop: "نمایش برترین",

    metricRevenue: "درآمد",
    metricSales: "فروش",
    metricProducts: "محصولات",
    metricUsers: "کاربران",

    timeRangeWeekly: "هفتگی",
    timeRangeMonthly: "ماهانه",
    timeRangeQuarterly: "سه ماهه",
    timeRangeYearly: "سالانه",

    statTopCompany: "شرکت برتر ({metric})",
    statTotal: "مجموع {metric}",
    statAverage: "میانگین {metric}",
    statTimeRange: "بازه زمانی",
    statAcrossCompanies: "از بین {count} شرکت",
    statPerCompany: "به ازای هر شرکت",
    statCurrentFilter: "فیلتر فعلی",

    chartTitle: "مقایسه {metric}",
    chartNoData: "داده‌ای برای نمودار وجود ندارد",

    companyListTitle: "{limit} شرکت برتر بر اساس {metric} ({timeRange})",
    companyListNoResults: "شرکتی مطابق با معیارهای شما یافت نشد",



    // Profile page
    profile: {
      title: "اطلاعات پروفایل",
      description: "اطلاعات پروفایل و آدرس ایمیل خود را به‌روزرسانی کنید",
      name: "نام",
      email: "ایمیل",
      unverified: "آدرس ایمیل شما تأیید نشده است.",
      resend_verification: "برای ارسال مجدد ایمیل تأیید کلیک کنید.",
      verification_sent: "پیوند تأیید جدید به ایمیل شما ارسال شد.",
      saved_success: "با موفقیت ذخیره شد"
    },
    password_update: {
      title: "به‌روزرسانی رمز عبور",
      description: "برای امنیت بیشتر، از رمز عبور طولانی و تصادفی استفاده کنید",
      current: "رمز عبور فعلی",
      new: "رمز عبور جدید",
      confirm: "تأیید رمز عبور",
      updated: "رمز عبور با موفقیت به‌روزرسانی شد",
      label: "رمز عبور"
    },
    acountDelete: {
      title: "حذف حساب کاربری",
      description: "حذف دائمی حساب کاربری و تمام اطلاعات آن",
      warning: "با حذف حساب، تمام داده‌های شما برای همیشه پاک خواهد شد. لطفاً قبل از حذف، اطلاعات خود را ذخیره کنید.",
      button: "حذف حساب",
      modal_title: "حذف حساب کاربری",
      modal_text: "آیا مطمئن هستید که می‌خواهید حساب خود را حذف کنید؟ این عمل غیرقابل بازگشت است."
    },
    common: {
      save: "ذخیره تغییرات",
      saving: "در حال ذخیره...",
      update: "به‌روزرسانی رمز عبور",
      updating: "در حال به‌روزرسانی...",
      delete: "حذف حساب",
      deleting: "در حال حذف...",
      cancel: "لغو"
    },

  
    //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ Company Part
   
    // User Dashboard page
    welcome: 'خوش آمدید',
    logged_in_as: 'شما وارد شدید به عنوان',
    today_sales: "فروش امروز",
    current_month_sale: 'فروش ماه جاری',
    total_sale: 'مجموع فروشات',
    total_today_sale: "فایده امروز",
    profit_current_month: 'فایده ماه جاری',
    total_profit_made: 'مجموع فایده ',
    expired_products: 'محصولات منقضی شده',
    user_added: 'کارمندان',
    active_users: 'کارمندان فعال',
    category_added: 'کتکوری',
    medicine_type_added: 'نوع دارو',
    product_added: 'تعداد محصول',
    purchase_added: 'تعداد خرید',
    stock_added: 'محصولات در گدام',
    low_stock_items: 'محصول با گدام پایین',
    high_stock_items: 'محصول با گدام بالا',
    motivation: {
      empoweringPharmacies: "توانمندسازی داروخانه‌ها با راه‌حل‌های هوشمند.",
      connectingPatients: "اتصال بیماران به خدمات بهتر درمانی.",
      revolutionizingDelivery: "انقلاب در نحوه تحویل دارو.",
      healthMission: "سلامتی شما، ماموریت ما.",
      healthPriority: "سلامتی شما، اولویت ماست.",
      innovatingCare: "نوآوری در مراقبت برای هر جامعه.",
      trustedHealthcare: "درمان قابل اعتماد، یک قدم جلوتر.",
      futureOfPharmacy: "ساخت آینده خدمات داروسازی.",
      qualityMedicines: "تحویل داروهای با کیفیت با دلسوزی.",
      safeHealing: "درمان ایمن، تجربه‌ای بدون دردسر."
    },



    // Bill.vue page
    invoice: 'فاکتور',
    thankYou: 'از خرید شما متشکریم!',
    customerDetails: 'جزئیات مشتری',
    name: 'نام',
    saleDate: 'تاریخ فروش',
    amountPaid: 'مبلغ پرداخت شده',
    orderDetails: 'جزئیات سفارش',
    productName: 'نام محصول',
    price: 'قیمت',
    quantity: 'تعداد',
    total: 'جمع کل',
    grandTotal: 'جمع کل نهایی',
    goBack: 'بازگشت',
    printBill: 'چاپ فاکتور',
    "invoiceNumber": "نمبر فاکتور",
    paid: 'پرداخت شده',


    // ViewProfile.vue page

    try: 'سلامتی بهترین سرمایه است!',
    company_address: 'آدرس:',
    company_email: 'ایمل:',
    company_phone: 'نمبر تلفون:',
    company_website: 'ویب سابت:',
    about_company: 'درباره ما:',
    update_profile: 'آپدیت پروفایل',
    add_profile: 'اضافه کردن پروفایل',
    system_settings: 'تنضیمات سیستم',
    app_currency: 'واحد پول',
    app_language: 'زبان',
    save_settings: 'ذخیره',
    get_backup: 'گرفتن پشتیبانی (Backup)',
    afghani: 'افغانی',
    dollar: 'دالر',
    english: 'انگلیسی',
    farsi: 'فارسی',
    user_role: 'نقش',



    // Add or Update Profile
    choose_logo: 'انتخاب لوگو یا برند',
    company_name: 'نام کمپنی',


    // UserDashboardLayout.vue page
    dashboard: 'داشبورد', 
    add: 'اضافه', 
    users: ' ● کارمندان', 
    category: '● کتگوری', 
    suppliers: '● تهیه کننده ها', 
    products: 'محصولات', 
    purchases: 'خرید ها', 
    stocks: 'گدام یا ذخیره',
    sales: 'فروشات', 
    sale_reports: ' گزارشات فروش', 
    today_reports: '● گزارش امروز', 
    basic_reports: '● گزارش معمولی', 
    adv_reports: '● گزارش پیشرفته', 
    sale_reversals: ' برگردانی فروشات', 
    add_reversals: '● اضافه کردن', 
    reversal_logs: '● قبلی ها', 
    expense: 'مصارف', 
    company_profile: 'پروفایل',
    user_profile: 'پروفایل کارمند',
    reversal_action: '● عمل برگردانی',
    approved_reversal: '● تصدیق شده ها',
    drug_type: '● نوعیت دارو', 


    // Company Users
    dashboard_add_user: 'داشبورد > اضافه کردن کارمند',
    add_new_user: 'اضافه کردن کارمند جدید',
    user_search_place: 'جستجو بر اساس نام یا ایمل..',
    register_new_user: 'راجستر کردن کارمند',
    user_id: 'آی دی',
    user_name: 'نام کارمند',
    user_email: ' ایمیل',
    user_image: 'عکس',
    user_phone: ' شماره تلفون',
    user_register_date: 'تاریخ ثبت',
    user_edit: ' آپدیت',
    user_delete: 'حذف',
    no_user_added: 'هیچ کارمندی ثبت نشده است',
    update_user: 'آپدیت کارمند',
    user_name: 'نام کارمند',
    user_email: 'ایمیل',
    update: 'آپدیت',
    cancel: 'لغو',
    confirm_delete: 'تایید حذف',
    confirm_message: 'مطمعن هستید که میخواهید حذف کنید؟ ',
    yes: 'بلی',
    no: 'نخیر',
    search_user: 'جستجوی کارمند بر اساس نام و ایمیل',
    page: 'صفحه',
    of: 'از',




    // Category.vue page
    dashboard_add_category: 'داشبورد > اضافه کردن کتگوری',
    add_new_category: 'اضافه کردن کتگوری جدید',
    category_search_place: 'جستجو بر اساس نام یا ایمل..',
    register_new_category: 'ثبت کتگوری جدید',
    loading: 'در حال پروسس... ',
    pdf: 'فایل pdf',
    category_id: 'آی دی',
    category_name: 'نام کتگوری',
    category_description: 'شرح',
    category_edit: ' آپدیت',
    category_delete: 'حذف',
    add_category: 'اضافه کردن',
    update_category: 'آپدیت کتگوری',
    search_category: 'جستجوی کتگوری بر اساس نام و شرح',
    no_category: 'هیچ کتگوری وجود ندارد',
    enter_category_name: 'نام کتگوری را وارد کنید',
    enter_category_desc : 'شرح کتگوری را وارد کنید',


    // Medicine Type page
    add_medicine_type: 'اضافه کزدن نوع جدید',
    dashboard_add_type: 'داشبورد > اضافه کزدن نوع جدید',
    search_type: 'جستجوی نوع بر اساس نام یا مخفف..',
    add_new_type: 'اضافه کزدن نوع جدید',
    type_id: 'آی دی نوع',
    type_name: 'نام',
    abreviation: 'مخفف',
    desc: 'شرح',
    action: 'عمل',
    update_type: 'آپدیت نوع دارو',
    medicine_type: 'نوعیت دارو',
    select_medicine_type: 'انتخاب نوعیت',
    enter_type_name: 'نام نوعیت را وارد کنید',
    enter_abreviation: 'مخفف را وارد کنید',
    enter_desc: 'شرح را وارد کنید',


    // Expense page
    expense_management: 'مدیریت مصارف',
    dashboard_expense: 'داشبورد > مصرف',
    search_expense: 'جستجوی مصارف بر اساس نوعیت آن',
    amount: 'مقدار',
    expense_type: 'نوعیت مصرف',
    expense_date: 'تاریخ',
    edit_expense: 'ادیت مصرف',
    add_new_expense: 'اضافه مصرف جدید',
    update_expense: 'آپدیت مصرف',
    add_expense: 'اصافه مصرف',




    // AuthenticatedLayout.vue page ///////////////////////// next part
    auth_profile: 'پروفایل',
    auth_logout: 'خروج',
    expired_product: 'محصولات منقضی شده',
    close: 'بستن',
    expired: 'منقضی شده است',
    no_expired_yet: 'هنوز محصولی منقضی نشده است',
    near_expired: 'محصولات نزدیک به منقضی شدن',
    no_near_expired: 'هیج محصولی نزدیک به منقضی شدن نیست',
    out_of_stock: 'محصولات خارج از گدام',
    expiration_date: 'تاریخ انقضا',
    confirm_backup: 'تصدیق پشتیبانی',
    confirm_backup_message: 'آیا شما مطمعن هستید برای پشتیبانی گیری؟',
    backup_path: 'مسیر فایل پشتیبانی : ',
    no_user_yet: 'هیچ کارمندی موجود نیست',
    no_active_user_yet: 'هیچ کارمندی فعال موجود نیست',
    user_activity: 'حالت کارمندان',
    active_users: 'کارمندان فعال',
    profile_image: 'پروفایل',
    user_address: 'آدرس',
    user_reg_date: 'تاریخ ثبت',
    user_last_seen: 'آخرین بازدید',
    stock_status_amount: 'مرز گدام پایین (Low Stock)',



    // Guest Layout page
    welcome_back: 'دوباره خوش آمدید',
    login_or_register_based_on_rule: ' لاگین یا راجستر یک کمپنی یا کارمند جدید و رفتن به داشبورد بر اساس نقش مربوطه ',
    remember_me: 'مرا به یاد داشته باش',
    forgot_password: 'آیا پسوورد را فراموش کرده اید؟',
    password: 'رمز عبور',


    // Register page
    "register": "ثبت نام",
    "name": "نام",
    "email": "ایمیل",
    "password": "رمز عبور",
    "confirm_password": "تأیید رمز عبور",
    "role": "نقش",
    "select_role": "یک نقش را انتخاب کنید",
    "sale_person": "فروشنده",
    "purchase_person": "مسئول خرید",
    "already_registered": "قبلاً ثبت نام کرده‌اید؟",



    // Today Sales Log
    today_sales_log: 'فروشات امروز',
    profit: 'فایده',
    sale_date: 'تاریخ فروش',
    total_today_sales_log: 'مجموع فروشات امروز',
    total_transaction: 'مجموع انتقالات',
    total_sales: 'مجموع فروشات',
    total_quantity: 'مجموع تعداد',
    total_profit: 'مجموع فایده',
    circle_graph: 'گراف دایروی از فروشات امروز',
    bar_chart: 'گراف میله یی از فروشات امروز',
    line_graph: 'گراف خط منکسر از فروشات امروز',




    // Basic Sales Log
    basic_circle_graph: 'گراف دایروی از فروشات سالانه',
    basic_bar_chart: 'گراف میله یی از فروشات سالانه',
    basic_line_graph: 'گراف خط منکسر از فروشات سالانه',
    recent_sales: 'فروشات اخیر',
    top_five_best_products: 'پنج محصول بیشترین فروش',
    current_month_sales: ' مجموع فروشات ماه جاری ',
    total_sales: 'مجموع کل فروشات',
    total_sales_details: 'همه فروشات با جزییات',
    current_month_sales_details: 'فروشات ماه جاری با جزییات',



    // Advanced Reports
    filter: 'فیلتر',
    from: ' از تاریخ',
    to: 'الی تاریخ',
    no_product_in_date: 'هیچ محصولی درین تاریخ وجود ندارد',
    all: 'همه',
    payment_status: 'حالت پرداخت',
    fully_paid: 'کامل پرداخت شده',
    partial_paid: 'پرداخت قسطی',
    reset: 'بازگردانی',


    // Checkout Summary page
    "customer_type": "نوع مشتری",
    "walk_in_customer": "مشتری حضوری",
    "partial": "جزئی",
    "select_customer": "انتخاب مشتری",
    "no_existing_customer": "-- بدون مشتری موجود --",
    "phone_number": "شماره تلفن",
    "phone_number_placeholder":"شماره تلفن",
    "email_placeholder": "آدرس ایمیل",
    "address_placeholder": "آدرس یا مکان",



    // Partial Customers
    "customers": "مشتریان",
    "search_customer": "جستجو بر اساس نام مشتری...",
    "tables": {
      "index": "ردیف",
      "customer_name": "نام مشتری",
      "total_amount": "مبلغ کل",
      "amount_paid": "مبلغ پرداختی",
      "remain": "باقیمانده",
      "action": "عملیات",
      "details": "جزئیات",
      "pay": "پرداخت"
    },
    "pagination": {
      "prev": "قبلی",
      "next": "بعدی"
    },
    "payment_form": {
      "title": "فرم پرداخت",
      "customer_name": "نام مشتری",
      "total_amount": "مبلغ کل",
      "amount_to_pay": "مبلغ پرداختی",
      "submit": "ثبت پرداخت"
    },
    "partial_customers": "مشتریان قسطی",
    "walkin_customers": "مشتریان حضوری",
    "customer_name": "نام مشتری",
    "total_amount": "مقدار کل",
    "amount_paid": "پرداخت شده",
    "remain": "باقیمانده",
    "sale_date": "تاریخ فروش",
    "details": "جزئیات",
    "products": "محصولات",
    "paids": "پرداخت‌ها",
    "prev": "قبلی",
    "next": "بعدی",
    "page": "صفحه",
    "of": "از",
    "products_for": "محصولات برای",
    "sale_date": "تاریخ فروش",
    "image": "تصویر",
    "product_name": "نام محصول",
    "price": "قیمت",
    "quantity": "تعداد",
    "total": "مجموع",
    "close": "بستن",
    "modal": {
    "productsFor": "محصولات برای",
    "paymentsFor": "پرداخت‌ها برای",
    "phone": "شماره تماس",
    "email": "ایمیل"
    },
    "table": {
      "image": "تصویر",
      "productName": "نام محصول",
      "price": "قیمت",
      "quantity": "تعداد",
      "total": "جمع",
      "saleId": "شناسه فروش",
      "totalAmount": "مبلغ کل",
      "amountPaid": "مبلغ پرداختی",
      "paymentDate": "تاریخ پرداخت"
    },
    "summary": {
      "totalAmount": "مجموع کل",
      "totalPaid": "مجموع پرداختی",
      "remaining": "باقی مانده"
    },
    "buttons": {
      "close": "بستن"
    },


    // Suppliers.vue page /////////// next part

    dashboard_add_supplier: 'داشبورد > اضافه کردن تهیه کننده',
    add_new_supplier: 'اضافه کردن تهیه کننده جدید',
    supplier_search_place: 'جستجو بر اساس نام ..',
    register_new_supplier: 'ثبت تهیه کننده جدید',
    supplier_phone: 'نمبر تلفون',
    supplier_name: 'نام تهیه کننده',
    supplier_address: 'آدرس ',
    supplier_email: 'ایمیل ',
    supplier_join_date: 'تاریخ پیوستن',
    supplier_total_money: 'مجموع پول',
    supplier_recieve_money: 'پول دریافت شده',
    supplier_remain_money: 'باقیمانده',
    actions: 'اعمال',
    supplier_payment: 'پرداخت',
    supplier_edit: ' آپدیت',
    supplier_delete: 'حذف',
    no_supplier: 'هیچ تهیه کننده یی وجود ندارد',
    contact_person: 'شخص تماس',
    update_supplier: 'آپدیت کردن تهیه کننده',
    make_payment: 'ایجاد پرداخت',
    payment_amount: 'مقدار پرداخت',
    payment_date: 'تاریخ پرداخت',
    payment_history: 'تاریخچه پرداخت ها',
    payment_number: 'شماره پرداخت',
    search_supplier: 'جستجوی تهیه کننده بر اساس نام..',
    no_payment: 'هیچ پرداختی نشده است!',




    // Products.vue page
    add_product: "افزودن محصول",
    dashboard: "داشبورد",
    search_placeholder: "جستجو بر اساس نام...",
    barcodes: "بارکدها",
    pdf: "فایل pdf",
    upload_excel: "آپلود با اکسل",
    add_new_product: "افزودن محصول جدید",
    product_id: "شناسه محصول",
    product_image: "تصویر محصول",
    max_size: 'حداکثر حجم',
    product_name: "نام محصول",
    stock_amount: "موجودی",
    stock_status: "وضعیت موجودی",
    purchase_price: "قیمت خرید",
    sale_price: "قیمت فروش",
    manufacturing_date: 'تاریخ تولید',
    expiry_date: 'تاریخ انقضا',
    barcode_number: 'نمبر بارکد',
    quantity: "تعداد",
    expiry: "انقضا",
    days: "روزها",
    action: "عملیات",
    no_product: "هنوز محصولی موجود نیست!",
    edit: 'آپدیت',
    delete: 'حذف',
    barcode: 'بارکد',
    product_category: 'کتگوری محصول',
    select_category: 'یک کتگوری انتخاب کنید',
    update_product: 'آپدیت محصول',
    no_date: 'بدون تاریخ',
    expired: 'منقضی شده',
    active: 'فعال',
    no_day: 'بدون روز',
    all_categories: "همه کتگوری",
    all_medicine_types: "همه نوع دارو",
    show_expired_only: "تنها منقضی شده",
    show_active_only: "تنها دارو های فعال",


    // BarcodePage
    barcode_page: 'صفحه بارکد',
    print_barcode: 'چاپ بارکد',
    all_barcode: 'تمام بارکد ها',


    // Purchases.vue page
    add_purchase: 'اضافه کردن خرید',
    dashboard_add_purchase: 'داشبورد > اضافه کردن خرید ',
    search_purchase: 'جستجو بر اساس محصول یا تهیه کننده',
    total_amount: 'مقدار مجموعی',
    purchase_date: 'تاریخ خرید',
    no_purchase: 'هیچ خریدی موجود نیست ',
    unit_price: 'قیمت واحد',
    update_purchase: 'آپدیت خرید',


    // Stocks.vue page
    add_stock: 'اضافه کردن گدام',
    dashboard_add_stock: 'داشبورد > اضافه کردن گدام',
    search_stock: 'جستجوی در گدام بر اساس نام محصول',
    no_stock_yet: 'هیچ محصول در گدام موجود نیست!',
    "modal_purchase": {
      "purchaseHistoryFor": "تاریخچه خرید برای"
    },
    "table_purchase": {
      "supplier": "تأمین‌کننده",
      "purchasePrice": "قیمت خرید",
      "quantity": "تعداد",
      "purchaseDate": "تاریخ خرید",
      "noHistoryFound": "هیچ تاریخچه خریدی برای این محصول یافت نشد."
    },



    // Sales.vue page
    search_drug: 'جستجوی دارو بر اساس نام',
    available: 'موجودی',
    add_to_card: 'اضافه کردن',
    empty_card: 'لیست خالی است',
    remove: 'حذف',
    total_price: 'قیمت مجموعی',
    checkout: 'تصفیه حساب',
    final_process: 'مرحله نهایی پروسه',
    customer_details: 'جزییات مشتری',
    customer_name: 'نام مشتری',
    date_of_sale: 'تاریخ فروش',
    amount_paid: 'مقدار پرداخت',
    pay_now: 'پرداخت',
    order_details: 'جزییات خرید',
    no_product_display: 'هیچ محصولی موجود نیست',
    enter_customer_name: 'نام مشتری را وارد کنید',
    enter_amount_paid: 'مقدار پرداخت را وارد کنید',
    remaining: 'باقیمانده',
    type: 'نوعیت',


    // add reversal
    reverse_sale: 'برگردانی فروشات',
    dashboard_reverse_sale: 'داشبورد > برگردانی فروشات',
    reverse: 'برگرداندن',
    no_sale_to_reverse: 'هیچ محصولی موجود نیست!',
    enter_reason: 'دلیل را وارد کنید',
    reversal_log: 'لیست برگردانی ها',
    dashboard_reversal_log: 'داشبورد > برگردانی ها',
    search_reversal_log: 'جستجوی برگردانی',
    users_id: 'آی دی کارمند',
    reverse_date: 'تاریخ برگردانی',
    reason: 'دلیل',
    status: 'حالت',
    no_reversal_log: 'هیچ برگردانی موجود نیست',


    // Reversal Action
    reverse_action: 'عمل برگردانی',
    dashboard_reverse_action: 'داشبورد > عمل برگردانی',
    search_reverse_action: 'جستجوی محصول',
    no_sale_to_approve: 'هیچ محصولی برای تصدیق وجود ندارد',
    confirm_approve: 'تایید تصدیق',
    approve_message: 'آیا مطمعن هستید برای تصدیق؟',
    approve: 'تصدیق',


    // Approved reversal
    approved_reversals: 'برگردانی های تصدیق شده',
    dashboard_approved: 'داشبورد > برگردانی تصدیق شده',
    search_approved: 'جستجوی محصول تصدیق شده',
    no_approved: 'هیچ محصولی تصدیق شده وجود ندارد',

    // Welcome header
    home: 'خانه',
    topCompanies: 'شرکت های برتر',
    searchDrugs: 'جستجوی داروها',
    features: 'ویژگی ها',
    ourServices: 'خدمات ما',
    contactUs: 'تماس با ما',
    dashboard: 'داشبورد',
    login: 'ورود',



    //================== Welcome page ============
    
      // Home Section
  "homeTitle": "سلامت شما، اولویت ما",
  "homeSubtitle": "توانمندسازی جوامع سالم‌تر با مراقبت‌های دارویی با کیفیت.",
  "seeDrugs": "مشاهده داروها",
  "learnMore": "اطلاعات بیشتر",

  // Top Companies Section
  "topCompaniesTitle": "کمپنی های مورد اعتماد دارویی",
  "topCompaniesSubtitle": "شرکت‌های شریک برتر ما را که محصولات دارویی با کیفیت و قابل اعتماد ارائه می‌دهند، بررسی کنید.",

  // // Search Drugs Section
  // "searchDrugsTitle": "داروها را سریع و مطمئن پیدا کنید",
  // "searchDrugsPlaceholder": "نام دارو را تایپ کنید...",

  // // Features Section
  // "featuresTitle": "چرا ما را انتخاب کنید",
  // "featuresSubtitle": "پلتفرم ما برای ساده‌سازی تجربه مدیریت داروخانه شما با سهولت استفاده و ویژگی‌های پیشرفته طراحی شده است.",

  // // Services Section
  // "servicesTitle": "راه‌حل‌های جامع داروخانه",
  // "servicesSubtitle": "از مدیریت موجودی تا اطمینان از خدمات کارآمد، ما طیف کاملی از راه‌حل‌ها را برای داروخانه شما ارائه می‌دهیم.",

  // // Contact Section
  // "contactTitle": "با ما در تماس باشید",
  // "contactSubtitle": "ما دوست داریم از شما بشنویم! چه سوالی داشته باشید و چه بازخوردی، امروز با ما تماس بگیرید.",
  // "contactNamePlaceholder": "نام شما",
  // "contactEmailPlaceholder": "ایمیل شما",
  // "contactMessagePlaceholder": "پیام شما",
  // "contactSubmitButton": "ارسال",

  // Footer
  "footerContact": "با ما تماس بگیرید: (+93(77)7566648) | (ghafoorsultani2002@gmail.com)",

  "companyAddress": "آدرس",
  "companyPhone": "شماره تلفن",
  "companyEmail": "ایمیل",
  "companyWebsite": "وبسایت",
  "companyAbout": "درباره",
  "company": "کمپنی",
  "address": "آدرس",
  "email": "ایمیل",
  "phone": "شماره تلفن",
  "about": "درباره",
  "website": "وبسایت",


  "featuresTitle": "ویژگی های ما",
  "featuresSubtitle": "همه چیزهایی که برای مدیریت موجودی خود نیاز دارید",
  "featureCards": {
    "inventory": "📦 مدیریت موجودی بلادرنگ",
    "inventoryDesc": "سطوح موجودی را نظارت کنید، هشدارهای پرکردن خودکار را تنظیم کنید و از کمبودها جلوگیری کنید.",
    "order": "🛒 پردازش سفارش یکپارچه",
    "orderDesc": "سفارشات را فوری ثبت کنید و محموله ها را با به روز رسانی های بلادرنگ پیگیری کنید.",
    "security": "🔐 سیستم ایمن و مطابق",
    "securityDesc": "با ذخیره سازی رمزگذاری شده داده و احراز هویت کاربر، انطباق مقررات را تضمین کنید.",
    "reporting": "📊 گزارش دهی پیشرفته",
    "reportingDesc": "گزارش های دقیق در مورد فروش، موجودی و رفتار مشتری ایجاد کنید.",
    "mobile": "📱 دسترسی موبایل",
    "mobileDesc": "از هر جایی با استفاده از برنامه موبایل ما به موجودی خود دسترسی داشته و سفارش دهید.",
    "integration": "🌐 ادغام چند کاناله",
    "integrationDesc": "با چندین کانال فروش ادغام شوید تا یک تجربه مدیریت موجودی یکپارچه داشته باشید."
  },
  "servicesTitle": "خدمات ما",
  "servicesSubtitle": "راه حل های جامع متناسب با نیازهای کسب و کار شما",
  "serviceCards": {
    "analytics": "📊 تحلیل کسب و کار",
    "analyticsDesc": "بینشی در مورد روند فروش، حرکت موجودی و رفتار مشتری به دست آورید.",
    "customer": "👥 مدیریت مشتری",
    "customerDesc": "سفارشات، ترجیحات و سابقه ارتباط با مشتری را پیگیری کنید.",
    "restocking": "🔄 پرکردن خودکار",
    "restockingDesc": "توصیه های هوشمند و سفارشات خودکار دریافت کنید.",
    "forecasting": "📈 پیش بینی فروش",
    "forecastingDesc": "روندهای فروش آینده را پیش بینی کنید و موجودی را بر این اساس برنامه ریزی کنید.",
    "warehouse": "📦 بهینه سازی انبار",
    "warehouseDesc": "چیدمان و عملیات انبار را برای حداکثر کارایی بهینه کنید.",
    "customReports": "📝 گزارش های سفارشی",
    "customReportsDesc": "گزارش های سفارشی متناسب با نیازهای کسب و کار خود ایجاد کنید."
  },
  "contactTitle": "تماس با ما",
  "contactCards": {
    "phone": "شماره تماس",
    "phoneValue": "+93 77756648",
    "email": "آدرس ایمیل",
    "emailValue": "ghafoorsultani2002@gmail.com",
    "website": "وب سایت",
    "websiteValue": "ghafoorsultani.me"
  },
  "contactForm": {
    "namePlaceholder": "نام خود را وارد کنید",
    "emailPlaceholder": "ایمیل خود را وارد کنید",
    "messagePlaceholder": "پیام خود را وارد کنید",
    "submitButton": "ارسال پیام"
  },


    "footer": {
    "about": {
      "title": "درباره ما",
      "description": "من دوست دارم با ابزارها و تکنولوژی های جدید کار کنم.",
      "socialLinks": "لینک های اجتماعی"
    },
    "quickLinks": {
      "title": "لینک های سریع",
      "home": "خانه",
      "companies": "شرکت های برتر",
      "search": "جستجوی داروها",
      "features": "ویژگی ها",
      "services": "خدمات",
      "contact": "تماس با ما"
    },
    "contact": {
      "title": "سوالی دارید؟",
      "phone": "+93 777566648",
      "email": "ghafoorsultani2002@gmail.com"
    },
    "copyright": "© {year} سیستم یکپارچه داروخانه. تمام حقوق محفوظ است."
  },

    
  },

pa: {
  pashto: 'پشتو',
  total_companies: 'ټولې شرکتونه',
  total_users: 'ټول کاروونکي',
  active_users: 'فعال کاروونکي',
  total_transactions: 'ټولې تراکنې',

  // Dashboard Layout
  dashboard_layout: "ډاشبورډ ترتیب",
  dashboard: "ډاشبورډ",
  companies: "شرکتونه",
  company_profiles: "د شرکت پروفایلونه",
  company_users: "د شرکت کاروونکي",
  data_reports: "د معلوماتو راپورونه",
  top_companies: "غوره شرکتونه",
  profile_layout: "پروفایل",
  logout: "وتل",

  // Common translations
  name: "نوم",
  email: "برېښنالیک",
  actions: "عملیات",
  update: "اوسمهال",
  cancel: "لغوه",
  yes: "هو",
  no: "نه",
  status: "حالت",
  lock: "قفل",
  unlock: "خلاص",
  page: "پاڼه",
  of: "له",

  // Company Management
  manage_companies: "د شرکتونو اداره",
  company_management: "د شرکتونو مدیریت",
  new_company: "نوی شرکت",
  search_placeholder: "د نوم یا برېښنالیک له مخې پلټنه...",
  update_company: "شرکت تازه کول",
  new_password: "نوې پاسورډ",
  confirm_password: "پاسورډ تایید کړئ",
  confirm_delete: "حذف تایید کړئ",
  delete_confirmation: "ایا تاسې باوري یاست چې غواړئ دا شرکت حذف کړئ؟",

  // Company Profiles
  profiles: "پروفایلونه",
  company_profiles: "د شرکت پروفایلونه",
  search_company_placeholder: "د شرکت د نوم یا پته له مخې پلټنه",
  logo: "لوګو",
  company_name: "د شرکت نوم",
  address: "پته",
  phone_number: "د اړیکې شمېره",
  website: "ویب‌سایټ",
  about: "په اړه",
  no_company: "هیڅ شرکت نشته!",

  // Company Users
  company_users: 'د شرکت کاروونکي',
  search_placeholder: 'د نوم، برېښنالیک یا شرکت له مخې پلټنه',
  all_companies: 'ټول شرکتونه',
  loading: 'په چمتو کولو کې...',
  profile_image: 'د پروفایل عکس',
  user_name: 'د کاروونکي نوم',
  email: 'برېښنالیک',
  address: 'پته',
  phone_number: 'د اړیکې شمېره',
  company_name: 'د شرکت نوم',
  last_seen: 'وروستی لیدل شوی',
  no_address: 'پته نشته',
  no_phone: 'شمېره نشته',
  never: 'هیڅکله نه',
  no_users_found: 'هیڅ کاروونکی ونه موندل شو',
  page: 'پاڼه',
  of: 'له',
  user_image: 'د کاروونکي عکس',

  // Reports
  reports_title: "د شرکتونو د معلوماتو راپورونه د سیسټم مدیر لپاره",
  reports_description: "د سیسټم فعالیت او تحلیلاتو بشپړه کتنه",
  filters: {
    date_range: "د نېټې موده",
    start_date: "د پیل نېټه",
    end_date: "د پای نېټه",
    company: "شرکت",
    all_companies: "ټول شرکتونه",
    generate_report: "راپور تولید کړئ"
  },
  date_range_options: {
    today: "نن",
    yesterday: "پرون",
    this_week: "دا اونۍ",
    last_week: "تیره اونۍ",
    this_month: "دا میاشت",
    last_month: "تیره میاشت",
    this_year: "سږ کال",
    last_year: "تیر کال",
    custom: "خپله ټاکل شوې موده"
  },
  summary_cards: {
    total_sales: "ټول پلور",
    total_profit: "ټول ګټه",
    items_sold: "فروخت شوي توکي",
    avg_sale_value: "اوسط د پلور ارزښت"
  },
  sections: {
    sales_by_company: "د شرکت له مخې پلور",
    stock_status: "د ذخیرې وضعیت",
    top_selling_products: "تر ټولو زیات پلورل شوي محصولات",
    low_stock_alerts: "د کمي ذخیرې خبرداری",
    out_of_stock_items: "نشتون توکي",
    recent_purchases: "وروستي پیرودونه"
  },
  table_headers: {
    company: "شرکت",
    total_sales: "ټول پلور",
    total_profit: "ټول ګټه",
    transactions: "تراکنې",
    product: "محصول",
    quantity_sold: "پلورل شوې اندازه",
    total_revenue: "ټول عواید"
  },
  status_labels: {
    low_stock: "کمه ذخیره",
    out_of_stock: "له ذخیرې خلاص",
    high_stock: "زیاته ذخیره"
  },
  no_data: {
    sales_data: "د ټاکل شوې مودې لپاره هیڅ پلور معلومات نشته",
    top_products: "هیڅ پرفروش محصول نشته",
    low_stock: "هیڅ کم ذخیرې توکي نشته",
    out_of_stock: "هیڅ توکي نشته چې له ذخیرې خلاص وي",
    recent_purchases: "هیڅ وروستي پیرود نشته"
  },
  units: {
    items: "توکي",
    units: "عدد",
    each: "په هر"
  },

  // Top Companies
  topCompaniesTitle: "غوره شرکتونه ✨",
  topCompaniesDescription: "د بیلابیلو معیارونو له مخې د شرکتونو فعالیت پرتله کړئ",

  filterMetric: "معیار",
  filterTimeRange: "د وخت موده",
  filterShowTop: "غوره ښودل",

  metricRevenue: "عواید",
  metricSales: "پلور",
  metricProducts: "محصولات",
  metricUsers: "کاروونکي",

  timeRangeWeekly: "اونیز",
  timeRangeMonthly: "میاشتنی",
  timeRangeQuarterly: "درې میاشتنی",
  timeRangeYearly: "کلنی",

  statTopCompany: "غوره شرکت ({metric})",
  statTotal: "ټولیز {metric}",
  statAverage: "اوسط {metric}",
  statTimeRange: "د وخت موده",
  statAcrossCompanies: "له {count} شرکتونو څخه",
  statPerCompany: "په هر شرکت کې",
  statCurrentFilter: "فعلي فلټر",

  chartTitle: "{metric} پرتله",
  chartNoData: "د چارت لپاره هیڅ معلومات نشته",

  companyListTitle: "غوره {limit} شرکتونه د {metric} له مخې ({timeRange})",
  companyListNoResults: "هیڅ شرکت ونه موندل شو چې له معیارونو سره برابر وي",

  // Profile Page
  profile: {
    title: "د پروفایل معلومات",
    description: "خپل پروفایل او برېښنالیک تازه کړئ",
    name: "نوم",
    email: "برېښنالیک",
    unverified: "ستاسو برېښنالیک تایید شوی نه دی.",
    resend_verification: "د تایید ایمیل بیا واستوئ.",
    verification_sent: "نوی تایید لینک ستاسو ایمیل ته واستول شو.",
    saved_success: "بریالۍ خوندي شو"
  },
  password_update: {
    title: "پاسورډ نوي کول",
    description: "د امنیت لپاره، یو اوږد او قوي پاسورډ وکاروئ",
    current: "اوسنی پاسورډ",
    new: "نوی پاسورډ",
    confirm: "پاسورډ تایید کړئ",
    updated: "پاسورډ بریالۍ نوي شو",
    label: "پاسورډ"
  },
  acountDelete: {
    title: "د حساب حذف",
    description: "ستاسو حساب او ټول معلومات دایمي حذف شي",
    warning: "د حذف وروسته، ستاسو ټول معلومات له منځه ځي. مهرباني وکړئ مخکې له حذف، معلومات خوندي کړئ.",
    button: "حساب حذف کړئ",
    modal_title: "د حساب حذف",
    modal_text: "ایا تاسې باوري یاست چې خپل حساب حذف کول غواړئ؟ دا عمل نه‌راګرځېدونکی دی."
  },
  common: {
    save: "بدلونونه خوندي کړئ",
    saving: "په خوندي کولو کې...",
    update: "پاسورډ تازه کړئ",
    updating: "په تازه کولو کې...",
    delete: "حساب حذف کړئ",
    deleting: "په حذف کې...",
    cancel: "لغوه",
  },

  welcome: "ښه راغلاست",
  "logged_in_as": "تاسو ننوتلي یاست لکه",
  "today_sales": "د نن ورځې خرڅلاو",
  "current_month_sale": "د روان میاشت خرڅلاو",
  "total_sale": "ټول خرڅلاو",
  "total_today_sale": "د نن ورځې ګټه",
  "profit_current_month": "د روان میاشت ګټه",
  "total_profit_made": "ټوله ګټه",
  "expired_products": "پرانستې شوې توکي",
  "user_added": "کارکوونکي",
  "active_users": "فعال کارکوونکي",
  "category_added": "کټګوري",
  "medicine_type_added": "د درملو ډول",
  "product_added": "د محصول شمېر",
  "purchase_added": "د پیرود شمېر",
  "stock_added": "په ګدام کې توکي",
  "low_stock_items": "توکي د ټیټ ګدام سره",
  "high_stock_items": "توکي د لوړ ګدام سره",
  "motivation": {
    "empoweringPharmacies": "د درملتونونو ځواکمنتیا د هوښیار حلونو سره.",
    "connectingPatients": "روغتیايي خدمتونو ته د ناروغانو وصلول.",
    "revolutionizingDelivery": "د درملو په تحویلي کې انقلاب.",
    "healthMission": "ستاسو روغتیا، زموږ ماموریت.",
    "healthPriority": "ستاسو روغتیا زموږ لومړیتوب دی.",
    "innovatingCare": "په هر ټولنه کې د پاملرنې نوښت.",
    "trustedHealthcare": "باوري درملنه، یو قدم مخکې.",
    "futureOfPharmacy": "د درملتونونو د خدماتو راتلونکی جوړول.",
    "qualityMedicines": "د کیفیت لرونکو درملو تحویلي په مهربانۍ.",
    "safeHealing": "مصؤنه درملنه، بې درد تجربه.",
  },
    "invoice": "بل",
    "thankYou": "ستاسو د پېرود لپاره مننه!",
    "customerDetails": "د مشتری جزئيات",
    "name": "نوم",
    "saleDate": "د خرڅلاو نیټه",
    "amountPaid": "تادیه شوی مقدار",
    "orderDetails": "د فرمایش جزئیات",
    "productName": "د محصول نوم",
    "price": "بیه",
    "quantity": "مقدار",
    "total": "ټولټال",
    "grandTotal": "ټولټال نهایی",
    "goBack": "شاته تګ",
    "printBill": "بل چاپول",
    "invoiceNumber": "د بل شمېره",
    "paid": "تادیه شوی",
    "try": "روغتیا تر ټولو غوره پانګه ده!",
    "company_address": "پته:",
    "company_email": "ایمیل:",
    "company_phone": "د تلیفون شمېره:",
    "company_website": "ویب پاڼه:",
    "about_company": "زموږ په اړه:",
    "update_profile": "پروفایل تازه کول",
    "add_profile": "پروفایل اضافه کول",
    "system_settings": "د سیسټم تنظیمات",
    "app_currency": "پولې واحد",
    "app_language": "ژبه",
    "save_settings": "خوندي کول",
    "get_backup": "بیک اپ ترلاسه کول",
    "afghani": "افغاني",
    "dollar": "ډالر",
    "english": "انګلیسي",
    "farsi": "فارسي",
    "user_role": "نقش",
    "choose_logo": "لوګو یا برانډ انتخاب کړئ",
    "company_name": "د کمپنۍ نوم",
    "add": "زیاتول",
    "users": "● کارکوونکي",
    "category": "● کټګوري",
    "suppliers": "● عرضه کوونکي",
    "products": "محصولات",
    "purchases": "پېرودنې",
    "stocks": "ګدام",
    "sales": "خرڅلاو",
    "sale_reports": "راپورونه",
    "today_reports": " ● نن ورځې راپورونه",
    "basic_reports": "● عادي راپورونه",
    "adv_reports": "● پرمختللي راپورونه",
    "sale_reversals": "د خرڅلاو بیرته ",
    "add_reversals": "● زیاتول",
    "reversal_logs": "● مخکېني",
    "expense": "مصارف",
    "company_profile": "پروفایل",
    "user_profile": "د کارونکي پروفایل",
    "reversal_action": "● عملیات",
    "approved_reversal": "● منل شوي",
    "drug_type": "● د درملو ډول",
    "dashboard_add_user": "ډشبورډ > کارمند اضافه کول",
    "add_new_user": "نوې کارمند اضافه کول",
    "user_search_place": "د نوم یا ایمیل له مخې لټون...",
    "register_new_user": "کارمند ثبتول",
    "user_id": "آی ډي",
    "user_name": "د کارمند نوم",
    "user_email": "ایمیل",
    "user_image": "انځور",
    "user_phone": "د تلیفون شمېره",
    "user_register_date": "د ثبت نیټه",
    "user_edit": "تازه کول",
    "user_delete": "حذفول",
    "no_user_added": "هیڅ کارمند ثبت شوی نه دی",
    "update_user": "کارمند تازه کول",
    "confirm_delete": "حذف تایید کړئ",
    "confirm_message": "باوري یاست چې غواړئ حذف یې کړئ؟",
    "yes": "هو",
    "no": "نه",
    "search_user": "د نوم او ایمیل له مخې لټون",
    "page": "پاڼه",
    "of": "له",
    "dashboard_add_category": "ډشبورډ > کټګوري اضافه کول",
    "add_new_category": "نوې کټګوري اضافه کول",
    "category_search_place": "د نوم یا ایمیل له مخې لټون...",
    "register_new_category": "نوې کټګوري ثبتول",
    "loading": "په پروسه کې...",
    "pdf": "د PDF فایل",
    "category_id": "آی ډي",
    "category_name": "د کټګوري نوم",
    "category_description": "شرح",
    "category_edit": "تازه کول",
    "category_delete": "حذفول",
    "add_category": "زیاتول",
    "update_category": "کټګوري تازه کول",
    "search_category": "د نوم او شرح له مخې لټون",
    "no_category": "هیڅ کټګوري نشته",
    "enter_category_name": "د کټګوري نوم ولیکئ",
    "enter_category_desc": "د کټګوري شرح ولیکئ",
    "add_medicine_type": "نوې ډوله اضافه کول",
    "dashboard_add_type": "ډشبورډ > نوې ډوله اضافه کول",
    "search_type": "د نوم یا لنډیز له مخې لټون...",
    "add_new_type": "نوې ډوله اضافه کول",
    "type_id": "ډول آی ډي",
    "type_name": "نوم",
    "abreviation": "لنډیز",
    "desc": "شرح",
    "action": "عملیات",
    "update_type": "ډول تازه کول",
    "medicine_type": "د درملو ډول",
    "select_medicine_type": "ډول انتخاب کړئ",
    "enter_type_name": "د ډول نوم ولیکئ",
    "enter_abreviation": "لنډیز ولیکئ",
    "enter_desc": "شرح ولیکئ",
    "expense_management": "د مصارفو مدیریت",
    "dashboard_expense": "ډشبورډ > مصارف",
    "search_expense": "د مصرف ډول له مخې لټون",
    "amount": "مقدار",
    "expense_type": "د مصرف ډول",
    "expense_date": "نېټه",
    "edit_expense": "مصرف اصلاح کول",
    "add_new_expense": "نوې مصرف اضافه کول",
    "update_expense": "مصرف تازه کول",
    "add_expense": "مصرف زیاتول",

    // AuthenticatedLayout.vue page
    "auth_profile": "پروفایل",
    "auth_logout": "وتل",
    "expired_product": "منقضی شوی محصولات",
    "close": "بندول",
    "expired": "منقضي شوی",
    "no_expired_yet": "تر اوسه هیڅ محصول منقضي شوی نه دی",
    "near_expired": "هغه محصولات چې نږدې منقضي کېږي",
    "no_near_expired": "هیڅ محصول نږدې منقضي کېدل نه لري",
    "out_of_stock": "له ګدامه بهر محصولات",
    "expiration_date": "د پای نیټه",
    "confirm_backup": "د بیک اپ تایید",
    "confirm_backup_message": "ایا تاسو ډاډه یاست چې بیک اپ جوړ کړئ؟",
    "backup_path": "د بیک اپ فایل لاره: ",
    "no_user_yet": "هیڅ کارکوونکی شتون نه لري",
    "no_active_user_yet": "هیڅ فعال کارکوونکی شتون نه لري",
    "user_activity": "د کارکوونکو حالت",
    "active_users": "فعال کارکوونکي",
    "profile_image": "پروفایل",
    "user_address": "پته",
    "user_reg_date": "د ثبت نېټه",
    "user_last_seen": "وروستۍ لیدنه",
    "stock_status_amount": "د ګدام ټیټه کچه (کم موجودي)",

    "welcome_back": "بیا ښه راغلاست",
    "login_or_register_based_on_rule": "لاګین یا د رول پراساس د یوې کمپنۍ یا نوي کارکوونکي ثبت او داشبورد ته تګ",
    "remember_me": "زه یاد کړه",
    "forgot_password": "پاسورډ مو هېر شوی؟",
    "password": "پټ نوم",

    "register": "ثبت نام",
    "name": "نوم",
    "email": "برېښنالیک",
    "password": "پټ نوم",
    "confirm_password": "د پټ نوم تایید",
    "role": "رول",
    "select_role": "یوه رول وټاکئ",
    "sale_person": "د خرڅلاو کارکوونکی",
    "purchase_person": "د پیرود مسؤل",
    "already_registered": "مخکې ثبت شوی یاست؟",

    "today_sales_log": "د نن ورځې پلور",
    "profit": "ګټه",
    "sale_date": "د پلور نېټه",
    "total_today_sales_log": "د نن ورځې ټول پلور",
    "total_transaction": "ټولې معاملې",
    "total_sales": "ټول پلور",
    "total_quantity": "ټول مقدار",
    "total_profit": "ټوله ګټه",
    "circle_graph": "د نن ورځې پلور دایروي ګراف",
    "bar_chart": "د نن ورځې پلور کالم ګراف",
    "line_graph": "د نن ورځې پلور خطي ګراف",

    "basic_circle_graph": "کلنۍ پلور دایروي ګراف",
    "basic_bar_chart": "کلنۍ پلور کالم ګراف",
    "basic_line_graph": "کلنۍ پلور خطي ګراف",
    "recent_sales": "وروستي پلورونه",
    "top_five_best_products": "د پنځو غوره محصولاتو پلور",
    "current_month_sales": "د روان میاشت پلور",
    "total_sales_details": "ټول پلور د تفصیل سره",
    "current_month_sales_details": "د روان میاشت پلور د تفصیل سره",
    "total_sales": "ټول پلور",

    "filter": "فلټر",
    "from": "له نېټې څخه",
    "to": "تر نېټې پورې",
    "no_product_in_date": "په دې نېټه هیڅ محصول نشته",
    "all": "ټول",
    "payment_status": "د تادیې حالت",
    "fully_paid": "بشپړ تادیه شوی",
    "partial_paid": "جزوي تادیه شوی",
    "reset": "بېرته تنظیمول",

    "customer_type": "د پیرودونکي ډول",
    "walk_in_customer": "حضوري پیرودونکی",
    "partial": "جزوي",
    "select_customer": "پیرودونکی وټاکئ",
    "no_existing_customer": "-- هیڅ موجود پیرودونکی نشته --",
    "phone_number": "د ټیلیفون شمېره",
    "phone_number_placeholder": "د ټیلیفون شمېره",
    "email_placeholder": "برېښنالیک پته",
    "address_placeholder": "پته یا ځای",

    "customers": "پیرودونکي",
    "search_customer": "د پیرودونکي په نوم لټون...",

    "tables": {
      "index": "شمېره",
      "customer_name": "د پیرودونکي نوم",
      "total_amount": "ټول اندازه",
      "amount_paid": "تادیه شوی مقدار",
      "remain": "باقي",
      "action": "عملیات",
      "details": "تفصیل",
      "pay": "تادیه"
    },

    "pagination": {
      "prev": "تېر",
      "next": "راتلونکی"
    },

    "payment_form": {
      "title": "د تادیې فورمه",
      "customer_name": "د پیرودونکي نوم",
      "total_amount": "ټول مقدار",
      "amount_to_pay": "د تادیې مقدار",
      "submit": "تادیه ثبتول"
    },

    "partial_customers": "جزوي پیرودونکي",
    "walkin_customers": "حضوري پیرودونکي",
    "customer_name": "د پیرودونکي نوم",
    "total_amount": "ټول مقدار",
    "amount_paid": "تادیه شوی",
    "remain": "باقي",
    "sale_date": "د پلور نېټه",
    "details": "تفصیل",
    "products": "محصولات",
    "paids": "تادیات",
    "prev": "تېر",
    "next": "راتلونکی",
    "page": "پاڼه",
    "of": "له",
    "products_for": "محصولات د",
    "sale_date": "د پلور نېټه",
    "image": "انځور",
    "product_name": "د محصول نوم",
    "price": "بیه",
    "quantity": "مقدار",
    "total": "ټول",
    "close": "بندول",

    "modal": {
      "productsFor": "محصولات د",
      "paymentsFor": "تادیات د",
      "phone": "د تماس شمېره",
      "email": "برېښنالیک"
    },

    "table": {
      "image": "انځور",
      "productName": "د محصول نوم",
      "price": "بیه",
      "quantity": "مقدار",
      "total": "ټول",
      "saleId": "د پلور شناخت",
      "totalAmount": "ټول مقدار",
      "amountPaid": "تادیه شوی مقدار",
      "paymentDate": "د تادیې نېټه"
    },

    "summary": {
      "totalAmount": "ټول مقدار",
      "totalPaid": "ټولې تادیې",
      "remaining": "باقي"
    },

    "buttons": {
      "close": "بندول"
    },









    //================ last part
  "dashboard_add_supplier": "ډشبورډ > د عرضه کوونکي اضافه کول",
  "add_new_supplier": "نوی عرضه کوونکی اضافه کړئ",
  "supplier_search_place": "د نوم له مخې لټون...",
  "register_new_supplier": "نوی عرضه کوونکی ثبت کړئ",
  "supplier_phone": "د تلیفون شمېره",
  "supplier_name": "د عرضه کوونکي نوم",
  "supplier_address": "پته",
  "supplier_email": "بریښنالیک",
  "supplier_join_date": "د ګډون نېټه",
  "supplier_total_money": "ټولې پیسې",
  "supplier_recieve_money": "ترلاسه شوې پیسې",
  "supplier_remain_money": "پاتې شوې پیسې",
  "actions": "عملونه",
  "supplier_payment": "تادیه",
  "supplier_edit": "سمون",
  "supplier_delete": "لېرې کول",
  "no_supplier": "هیڅ عرضه کوونکی شتون نلري",
  "contact_person": "د اړیکې کس",
  "update_supplier": "د عرضه کوونکي تازه کول",
  "make_payment": "تادیه کول",
  "payment_amount": "د تادیې اندازه",
  "payment_date": "د تادیې نېټه",
  "payment_history": "د تادیاتو تاریخچه",
  "payment_number": "د تادیې شمېره",
  "search_supplier": "د عرضه کوونکي د نوم له مخې لټون...",
  "no_payment": "هیڅ تادیه نه ده شوې!",

  "add_product": "محصول اضافه کړئ",
  "dashboard": "ډشبورډ",
  "search_placeholder": "د نوم له مخې لټون...",
  "barcodes": "بارکوډونه",
  "pdf": "PDF فایل",
  "upload_excel": "د اکسېل له لارې اپلوډ",
  "add_new_product": "نوی محصول اضافه کړئ",
  "product_id": "د محصول پېژند نمبر",
  "product_image": "د محصول انځور",
  "max_size": "اعظمي اندازه",
  "product_name": "د محصول نوم",
  "stock_amount": "ذخیره",
  "stock_status": "د ذخیرې وضعیت",
  "purchase_price": "د اخیستلو قیمت",
  "sale_price": "د پلور قیمت",
  "manufacturing_date": "د جوړولو نېټه",
  "expiry_date": "د ختمېدو نېټه",
  "barcode_number": "د بارکوډ شمېره",
  "quantity": "مقدار",
  "expiry": "ختمېدل",
  "days": "ورځې",
  "action": "عمل",
  "no_product": "لا هم کوم محصول نشته!",
  "edit": "سمول",
  "delete": "لېرې کول",
  "barcode": "بارکوډ",
  "product_category": "د محصول کټګوري",
  "select_category": "یوه کټګوري وټاکئ",
  "update_product": "محصول تازه کړئ",
  "no_date": "بې نېټې",
  "expired": "ختم شوی",
  "active": "فعال",
  "no_day": "بې ورځو",
  "all_categories": "ټولې کټګورۍ",
  "all_medicine_types": "ټول د درملو ډولونه",
  "show_expired_only": "یوازې ختم شوي وښایئ",
  "show_active_only": "یوازې فعال درمل وښایئ",

  "barcode_page": "د بارکوډ پاڼه",
  "print_barcode": "بارکوډ چاپ کړئ",
  "all_barcode": "ټول بارکوډونه",

  "add_purchase": "نوې پېرود اضافه کړئ",
  "dashboard_add_purchase": "ډشبورډ > نوې پېرود اضافه کول",
  "search_purchase": "د محصول یا عرضه کوونکي له مخې لټون",
  "total_amount": "ټول مقدار",
  "purchase_date": "د پېرود نېټه",
  "no_purchase": "هیڅ پېرود نشته",
  "unit_price": "د واحد قیمت",
  "update_purchase": "پېرود تازه کړئ",

  "add_stock": "ذخیره اضافه کړئ",
  "dashboard_add_stock": "ډشبورډ > ذخیره اضافه کول",
  "search_stock": "د محصول د نوم له مخې په ذخیره کې لټون",
  "no_stock_yet": "تر اوسه په ذخیره کې کوم محصول نشته!",
  "modal_purchase": {
    "purchaseHistoryFor": "د پېرود تاریخچه د"
  },
  "table_purchase": {
    "supplier": "عرضه کوونکی",
    "purchasePrice": "د اخیستلو قیمت",
    "quantity": "مقدار",
    "purchaseDate": "د پېرود نېټه",
    "noHistoryFound": "د دې محصول لپاره هیڅ تاریخچه ونه موندل شوه."
  },

  "search_drug": "د درملو د نوم له مخې لټون",
  "available": "موجود",
  "add_to_card": "زیاتول",
  "empty_card": "لیست خالي دی",
  "remove": "لېرې کول",
  "total_price": "ټول قیمت",
  "checkout": "تادیه کول",
  "final_process": "وروستی پړاو",
  "customer_details": "د پیرودونکي جزییات",
  "customer_name": "د پیرودونکي نوم",
  "date_of_sale": "د خرڅلاو نېټه",
  "amount_paid": "تادیه شوی مقدار",
  "pay_now": "همدا اوس تادیه کړئ",
  "order_details": "د خرڅلاو جزییات",
  "no_product_display": "هیڅ محصول شتون نلري",
  "enter_customer_name": "د پیرودونکي نوم ولیکئ",
  "enter_amount_paid": "تادیه شوی مقدار ولیکئ",
  "remaining": "پاتې",
  "type": "ډول",

  "reverse_sale": "د خرڅلاو بیرته اخیستل",
  "dashboard_reverse_sale": "ډشبورډ > د خرڅلاو بیرته اخیستل",
  "reverse": "بیرته اخیستل",
  "no_sale_to_reverse": "هیڅ محصول شتون نلري!",
  "enter_reason": "د لامل ولیکئ",
  "reversal_log": "د بیرته اخیستلو لړلیک",
  "dashboard_reversal_log": "ډشبورډ > د بیرته اخیستلو لړلیک",
  "search_reversal_log": "د بیرته اخیستلو لټون",
  "users_id": "د کارونکي آی ډی",
  "reverse_date": "د بیرته اخیستلو نېټه",
  "reason": "لیل",
  "status": "حالت",
  "no_reversal_log": "هیڅ بیرته اخیستل شتون نلري",

  "reverse_action": "د بیرته اخیستلو عمل",
  "dashboard_reverse_action": "ډشبورډ > د بیرته اخیستلو عمل",
  "search_reverse_action": "د محصول لټون",
  "no_sale_to_approve": "د تایید لپاره هیڅ محصول نشته",
  "confirm_approve": "د تایید تصدیق وکړئ",
  "approve_message": "ډاډه یاست چې تایید کول غواړئ؟",
  "approve": "تایید کړئ",

  "approved_reversals": "تایید شوي بیرته اخیستنې",
  "dashboard_approved": "ډشبورډ > تایید شوي بیرته اخیستنې",
  "search_approved": "د تایید شوي محصول لټون",
  "no_approved": "هیڅ تایید شوی محصول شتون نلري",

  "home": "کور",
  "topCompanies": "مشهوره شرکتونه",
  "searchDrugs": "د درملو لټون",
  "features": "ځانګړتیاوې",
  "ourServices": "زموږ خدمتونه",
  "contactUs": "موږ سره اړیکه",
  "dashboard": "ډشبورډ",
  "login": "ننوتل",

  "homeTitle": "ستاسې روغتیا، زموږ لومړیتوب",
  "homeSubtitle": "د لوړ کیفیت درملنې په مرسته روغ او ځواکمن ټولنې جوړول.",
  "seeDrugs": "درمل وګورئ",
  "learnMore": "نور زده کړئ",

  "topCompaniesTitle": "باوري درمل جوړونکي شرکتونه",
  "topCompaniesSubtitle": "زموږ مخکښ شریکان وګورئ چې لوړ کیفیت او باور لرونکي درمل وړاندې کوي.",

  // "searchDrugsTitle": "درمل په چټکۍ او باور سره پیدا کړئ",
  // "searchDrugsPlaceholder": "د درمل نوم ولیکئ...",

  // "featuresTitle": "ولې موږ غوره کړئ",
  // "featuresSubtitle": "زموږ پلاتفورم د درملتون مدیریت اسانه کولو لپاره پرمختللې او ساده ځانګړتیاوې لري.",

  // "servicesTitle": "د درملتون بشپړ حلونه",
  // "servicesSubtitle": "له ذخیرې مدیریت تر اغیزمن خدمتونو پورې، موږ هر څه وړاندې کوو.",

  // "contactTitle": "موږ سره اړیکه ونیسئ",
  // "contactSubtitle": "موږ ستاسو پوښتنو او نظرونو ته خوشحاله یو. نن ورځ موږ سره اړیکه ونیسئ.",
  // "contactNamePlaceholder": "ستاسې نوم",
  // "contactEmailPlaceholder": "ستاسې بریښنالیک",
  // "contactMessagePlaceholder": "ستاسې پیغام",
  // "contactSubmitButton": "لیږل",

  "footerContact": "موږ سره اړیکه: (+93(77)7566648) | (ghafoorsultani2002@gmail.com)",

  "companyAddress": "پته",
  "companyPhone": "د تلیفون شمېره",
  "companyEmail": "بریښنالیک",
  "companyWebsite": "وېبپاڼه",
  "companyAbout": "زموږ په اړه",
  "company": "شرکت",
  "address": "پته",
  "email": "بریښنالیک",
  "phone": "د تلیفون شمېره",
  "about": "زموږ په اړه",
  "website": "وېبپاڼه",


    "featuresTitle": "زموږ ځانګړتیاوې",
  "featuresSubtitle": "هغه هرڅه چې تاسو یې د خپل موجودي د مدیریت لپاره اړتیا لرئ",
  "featureCards": {
    "inventory": "📦 د ریښتینی وخت د موجودي مدیریت",
    "inventoryDesc": "د توکو کچه وګورئ، د اتوماتیک بیاځای کولو خبرتیاوې وټاکئ او د کمښتونو څخه مخنیوی وکړئ.",
    "order": "🫳 د سپارښت پرېښودل په اسانۍ سره",
    "orderDesc": "په ډېرې اسانۍ سره سپارښت وکړئ او د ریښتینی وخت تازه معلوماتو سره لیږدونه تعقیب کړئ.",
    "security": "🔐 خوندي او مطابقه سیستم",
    "securityDesc": "د معلوماتو د خوندي ساتنې او د کارونکي تصدیق سره د مقرراتو پلي کول تضمین کړئ.",
    "reporting": "📊 پرمختللې راپورونه",
    "reportingDesc": "په خرڅلاو، موجودي او د پیرودونکي چلند باندې تفصيلي راپورونه جوړ کړئ.",
    "mobile": "📱 د موبایل لاسرسی",
    "mobileDesc": "زموږ د موبایل اپلیکیشن په کارولو سره له هرځایه خپل موجودي ته لاسرسی ومومئ او سپارښت وکړئ.",
    "integration": "🌐 د ګڼ چینل یوځای کول",
    "integrationDesc": "د یوځای شوي موجودي د مدیریت تجربې لپاره له ګڼو خرڅلاو چینلونو سره یوځای شئ."
  },
  "servicesTitle": "زموږ خدمتونه",
  "servicesSubtitle": "ستاسو د سوداګریزو اړتیاوو سره سم جامع حلونه",
  "serviceCards": {
    "analytics": "📊 سوداګریز تحلیل",
    "analyticsDesc": "په خرڅلاو رجحانات، د توکو حرکت او د پیرودونکي چلند کې بصیرت ترلاسه کړئ.",
    "customer": "👥 د پیرودونکي مدیریت",
    "analyticsDesc": "د پیرودونکي سپارښتونه، غوره توبونه او د اړیکو تاریخچه تعقیب کړئ.",
    "restocking": "🔄 اتومات بیاځای کول",
    "restockingDesc": "هوشمند سپارښتونه او اتومات سپارښتونه ترلاسه کړئ.",
    "forecasting": "📈 د خرڅلاو وړاندوینه",
    "forecastingDesc": "د راتلونکي خرڅلاو رجحانات وړاندوینه وکړئ او موجودي په دې اساس تنظیم کړئ.",
    "warehouse": "📦 د ګودام اصلاح",
    "warehouseDesc": "د ګودام ترتیب او عملیات د اعظمي کاري کچې لپاره اصلاح کړئ.",
    "customReports": "📝 دودیز راپورونه",
    "customReportsDesc": "ستاسو د سوداګریزو اړتیاوو سره سم دودیز راپورونه جوړ کړئ."
  },
  "contactTitle": "موږ سره اړیکه",
  "contactCards": {
    "phone": "د اړیکې شمېره",
    "phoneValue": "+93 77756648",
    "email": "بریښنالیک پته",
    "emailValue": "ghafoorsultani2002@gmail.com",
    "website": "وېب پاڼه",
    "websiteValue": "ghafoorsultani.me"
  },
  "contactForm": {
    "namePlaceholder": "خپل نوم ولیکئ",
    "emailPlaceholder": "خپل بریښنالیک ولیکئ",
    "messagePlaceholder": "خپل پیام ولیکئ",
    "submitButton": "پیام واستوئ"
  },


  "footer": {
    "about": {
      "title": "زموږ په اړه",
      "description": "زه نوي اوزارونو او ټیکنالوژۍ سره کار کول خوښوم.",
      "socialLinks": "ټولنیز لینکونه"
    },
    "quickLinks": {
      "title": "چټک لینکونه",
      "home": "کور",
      "companies": "مخکښ شرکتونه",
      "search": "درمل پلټل",
      "features": "ځانګړتیاوې",
      "services": "خدمتونه",
      "contact": "موږ سره اړیکه"
    },
    "contact": {
      "title": "پوښتنه لرئ؟",
      "phone": "+93 777566648",
      "email": "ghafoorsultani2002@gmail.com"
    },
    "copyright": "© {year} متحد درملتون سیسټم. ټول حقونه خوندي دي."
  },

}

};

const i18n = createI18n({
  legacy: false, // Use Composition API mode
  locale: localStorage.getItem('language') || 'en', // Default language
  messages
});

export default i18n;