import './bootstrap';
import '../css/app.css';
import axios from 'axios';

import { createApp, h } from 'vue';
import { createInertiaApp } from '@inertiajs/vue3';
import { resolvePageComponent } from 'laravel-vite-plugin/inertia-helpers';
import { ZiggyVue } from '../../vendor/tightenco/ziggy';
import i18n from '@/i18n';
import Toast, { POSITION } from 'vue-toastification';
import 'vue-toastification/dist/index.css';

// Set the CSRF token in Axios headers
// axios.defaults.headers.common['X-CSRF-TOKEN'] = csrfToken;

const appName = import.meta.env.VITE_APP_NAME || 'Laravel';

createInertiaApp({
    title: (title) => `${title} - ${appName}`,
    resolve: (name) => resolvePageComponent(`./Pages/${name}.vue`, import.meta.glob('./Pages/**/*.vue')),
    setup({ el, App, props, plugin }) {
        const app = createApp({ render: () => h(App, props) })
            .use(i18n)
            .use(plugin)
            .use(ZiggyVue)
            .use(Toast, {  // Add Toast plugin here
                position: POSITION.TOP_RIGHT,
                timeout: 5000,
                closeOnClick: false,
                pauseOnHover: true,
                draggable: true,
                draggablePercent: 0.6,
                showCloseButtonOnHover: true,
                hideProgressBar: false,
                closeButton: 'button',
                icon: true,
            });
        
        app.mount(el);
    },
    progress: {
        color: '#4B5563',
    },
});
