(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define(["require", "exports", "./OutOfCanvasUpdater.js"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.loadOutModesUpdater = loadOutModesUpdater;
    const OutOfCanvasUpdater_js_1 = require("./OutOfCanvasUpdater.js");
    async function loadOutModesUpdater(engine, refresh = true) {
        engine.checkVersion("3.9.1");
        await engine.addParticleUpdater("outModes", container => {
            return Promise.resolve(new OutOfCanvasUpdater_js_1.OutOfCanvasUpdater(container));
        }, refresh);
    }
});
