/*!
 * Author : Matteo Bruni
 * MIT license: https://opensource.org/licenses/MIT
 * Demo / Generator : https://particles.js.org/
 * GitHub : https://www.github.com/matteobruni/tsparticles
 * How to use? : Check the GitHub README
 * v3.9.1
 */
/*
 * ATTENTION: The "eval" devtool has been used (maybe by default in mode: "development").
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory(require("@tsparticles/engine"));
	else if(typeof define === 'function' && define.amd)
		define(["@tsparticles/engine"], factory);
	else {
		var a = typeof exports === 'object' ? factory(require("@tsparticles/engine")) : factory(root["window"]);
		for(var i in a) (typeof exports === 'object' ? exports : root)[i] = a[i];
	}
})(this, (__WEBPACK_EXTERNAL_MODULE__tsparticles_engine__) => {
return /******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./dist/browser/PolygonDrawer.js":
/*!***************************************!*\
  !*** ./dist/browser/PolygonDrawer.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   PolygonDrawer: () => (/* binding */ PolygonDrawer)\n/* harmony export */ });\n/* harmony import */ var _PolygonDrawerBase_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./PolygonDrawerBase.js */ \"./dist/browser/PolygonDrawerBase.js\");\n\nconst sidesCenterFactor = 3.5,\n  yFactor = 2.66,\n  sidesFactor = 3;\nclass PolygonDrawer extends _PolygonDrawerBase_js__WEBPACK_IMPORTED_MODULE_0__.PolygonDrawerBase {\n  constructor() {\n    super(...arguments);\n    this.validTypes = [\"polygon\"];\n  }\n  getCenter(particle, radius) {\n    return {\n      x: -radius / (particle.sides / sidesCenterFactor),\n      y: -radius / (yFactor / sidesCenterFactor)\n    };\n  }\n  getSidesData(particle, radius) {\n    const sides = particle.sides;\n    return {\n      count: {\n        denominator: 1,\n        numerator: sides\n      },\n      length: radius * yFactor / (sides / sidesFactor)\n    };\n  }\n}\n\n//# sourceURL=webpack://@tsparticles/shape-polygon/./dist/browser/PolygonDrawer.js?\n}");

/***/ }),

/***/ "./dist/browser/PolygonDrawerBase.js":
/*!*******************************************!*\
  !*** ./dist/browser/PolygonDrawerBase.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   PolygonDrawerBase: () => (/* binding */ PolygonDrawerBase)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"@tsparticles/engine\");\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _Utils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Utils.js */ \"./dist/browser/Utils.js\");\n\n\nconst defaultSides = 5;\nclass PolygonDrawerBase {\n  draw(data) {\n    const {\n        particle,\n        radius\n      } = data,\n      start = this.getCenter(particle, radius),\n      side = this.getSidesData(particle, radius);\n    (0,_Utils_js__WEBPACK_IMPORTED_MODULE_1__.drawPolygon)(data, start, side);\n  }\n  getSidesCount(particle) {\n    const polygon = particle.shapeData;\n    return Math.round((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(polygon?.sides ?? defaultSides));\n  }\n}\n\n//# sourceURL=webpack://@tsparticles/shape-polygon/./dist/browser/PolygonDrawerBase.js?\n}");

/***/ }),

/***/ "./dist/browser/TriangleDrawer.js":
/*!****************************************!*\
  !*** ./dist/browser/TriangleDrawer.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   TriangleDrawer: () => (/* binding */ TriangleDrawer)\n/* harmony export */ });\n/* harmony import */ var _PolygonDrawerBase_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./PolygonDrawerBase.js */ \"./dist/browser/PolygonDrawerBase.js\");\n\nconst yFactor = 1.66,\n  sides = 3,\n  double = 2;\nclass TriangleDrawer extends _PolygonDrawerBase_js__WEBPACK_IMPORTED_MODULE_0__.PolygonDrawerBase {\n  constructor() {\n    super(...arguments);\n    this.validTypes = [\"triangle\"];\n  }\n  getCenter(particle, radius) {\n    return {\n      x: -radius,\n      y: radius / yFactor\n    };\n  }\n  getSidesCount() {\n    return sides;\n  }\n  getSidesData(particle, radius) {\n    const diameter = radius * double;\n    return {\n      count: {\n        denominator: 2,\n        numerator: 3\n      },\n      length: diameter\n    };\n  }\n}\n\n//# sourceURL=webpack://@tsparticles/shape-polygon/./dist/browser/TriangleDrawer.js?\n}");

/***/ }),

/***/ "./dist/browser/Utils.js":
/*!*******************************!*\
  !*** ./dist/browser/Utils.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   drawPolygon: () => (/* binding */ drawPolygon)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"@tsparticles/engine\");\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__);\n\nconst piDeg = 180,\n  origin = {\n    x: 0,\n    y: 0\n  },\n  sidesOffset = 2;\nfunction drawPolygon(data, start, side) {\n  const {\n      context\n    } = data,\n    sideCount = side.count.numerator * side.count.denominator,\n    decimalSides = side.count.numerator / side.count.denominator,\n    interiorAngleDegrees = piDeg * (decimalSides - sidesOffset) / decimalSides,\n    interiorAngle = Math.PI - (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.degToRad)(interiorAngleDegrees);\n  if (!context) {\n    return;\n  }\n  context.beginPath();\n  context.translate(start.x, start.y);\n  context.moveTo(origin.x, origin.y);\n  for (let i = 0; i < sideCount; i++) {\n    context.lineTo(side.length, origin.y);\n    context.translate(side.length, origin.y);\n    context.rotate(interiorAngle);\n  }\n}\n\n//# sourceURL=webpack://@tsparticles/shape-polygon/./dist/browser/Utils.js?\n}");

/***/ }),

/***/ "./dist/browser/index.js":
/*!*******************************!*\
  !*** ./dist/browser/index.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   loadGenericPolygonShape: () => (/* binding */ loadGenericPolygonShape),\n/* harmony export */   loadPolygonShape: () => (/* binding */ loadPolygonShape),\n/* harmony export */   loadTriangleShape: () => (/* binding */ loadTriangleShape)\n/* harmony export */ });\n/* harmony import */ var _PolygonDrawer_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./PolygonDrawer.js */ \"./dist/browser/PolygonDrawer.js\");\n/* harmony import */ var _TriangleDrawer_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./TriangleDrawer.js */ \"./dist/browser/TriangleDrawer.js\");\n\n\nasync function loadGenericPolygonShape(engine, refresh = true) {\n  engine.checkVersion(\"3.9.1\");\n  await engine.addShape(new _PolygonDrawer_js__WEBPACK_IMPORTED_MODULE_0__.PolygonDrawer(), refresh);\n}\nasync function loadTriangleShape(engine, refresh = true) {\n  engine.checkVersion(\"3.9.1\");\n  await engine.addShape(new _TriangleDrawer_js__WEBPACK_IMPORTED_MODULE_1__.TriangleDrawer(), refresh);\n}\nasync function loadPolygonShape(engine, refresh = true) {\n  engine.checkVersion(\"3.9.1\");\n  await loadGenericPolygonShape(engine, refresh);\n  await loadTriangleShape(engine, refresh);\n}\n\n//# sourceURL=webpack://@tsparticles/shape-polygon/./dist/browser/index.js?\n}");

/***/ }),

/***/ "@tsparticles/engine":
/*!*********************************************************************************************************************************!*\
  !*** external {"commonjs":"@tsparticles/engine","commonjs2":"@tsparticles/engine","amd":"@tsparticles/engine","root":"window"} ***!
  \*********************************************************************************************************************************/
/***/ ((module) => {

module.exports = __WEBPACK_EXTERNAL_MODULE__tsparticles_engine__;

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module can't be inlined because the eval devtool is used.
/******/ 	var __webpack_exports__ = __webpack_require__("./dist/browser/index.js");
/******/ 	
/******/ 	return __webpack_exports__;
/******/ })()
;
});