(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define(["require", "exports", "./Utils.js", "./ImageDrawer.js", "./ImagePreloader.js", "@tsparticles/engine", "./GifUtils/Utils.js"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.loadImageShape = loadImageShape;
    const Utils_js_1 = require("./Utils.js");
    const ImageDrawer_js_1 = require("./ImageDrawer.js");
    const ImagePreloader_js_1 = require("./ImagePreloader.js");
    const engine_1 = require("@tsparticles/engine");
    const Utils_js_2 = require("./GifUtils/Utils.js");
    const extLength = 3;
    function addLoadImageToEngine(engine) {
        if (engine.loadImage) {
            return;
        }
        engine.loadImage = async (data) => {
            if (!data.name && !data.src) {
                throw new Error(`${engine_1.errorPrefix} no image source provided`);
            }
            if (!engine.images) {
                engine.images = [];
            }
            if (engine.images.find((t) => t.name === data.name || t.source === data.src)) {
                return;
            }
            try {
                const image = {
                    gif: data.gif ?? false,
                    name: data.name ?? data.src,
                    source: data.src,
                    type: data.src.substring(data.src.length - extLength),
                    error: false,
                    loading: true,
                    replaceColor: data.replaceColor,
                    ratio: data.width && data.height ? data.width / data.height : undefined,
                };
                engine.images.push(image);
                let imageFunc;
                if (data.gif) {
                    imageFunc = Utils_js_2.loadGifImage;
                }
                else {
                    imageFunc = data.replaceColor ? Utils_js_1.downloadSvgImage : Utils_js_1.loadImage;
                }
                await imageFunc(image);
            }
            catch {
                throw new Error(`${engine_1.errorPrefix} ${data.name ?? data.src} not found`);
            }
        };
    }
    async function loadImageShape(engine, refresh = true) {
        engine.checkVersion("3.9.1");
        addLoadImageToEngine(engine);
        const preloader = new ImagePreloader_js_1.ImagePreloaderPlugin(engine);
        await engine.addPlugin(preloader, refresh);
        await engine.addShape(new ImageDrawer_js_1.ImageDrawer(engine), refresh);
    }
});
