/*!
 * Author : Matteo Bruni
 * MIT license: https://opensource.org/licenses/MIT
 * Demo / Generator : https://particles.js.org/
 * GitHub : https://www.github.com/matteobruni/tsparticles
 * How to use? : Check the GitHub README
 * v3.9.1
 */
/*
 * ATTENTION: The "eval" devtool has been used (maybe by default in mode: "development").
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory(require("@tsparticles/engine"));
	else if(typeof define === 'function' && define.amd)
		define(["@tsparticles/engine"], factory);
	else {
		var a = typeof exports === 'object' ? factory(require("@tsparticles/engine")) : factory(root["window"]);
		for(var i in a) (typeof exports === 'object' ? exports : root)[i] = a[i];
	}
})(this, (__WEBPACK_EXTERNAL_MODULE__tsparticles_engine__) => {
return /******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./dist/browser/CircleWarp.js":
/*!************************************!*\
  !*** ./dist/browser/CircleWarp.js ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   CircleWarp: () => (/* binding */ CircleWarp)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"@tsparticles/engine\");\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__);\n\nconst double = 2;\nclass CircleWarp extends _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.Circle {\n  constructor(x, y, radius, canvasSize) {\n    super(x, y, radius);\n    this.canvasSize = canvasSize;\n    this.canvasSize = {\n      ...canvasSize\n    };\n  }\n  contains(point) {\n    const {\n        width,\n        height\n      } = this.canvasSize,\n      {\n        x,\n        y\n      } = point;\n    return super.contains(point) || super.contains({\n      x: x - width,\n      y\n    }) || super.contains({\n      x: x - width,\n      y: y - height\n    }) || super.contains({\n      x,\n      y: y - height\n    });\n  }\n  intersects(range) {\n    if (super.intersects(range)) {\n      return true;\n    }\n    const rect = range,\n      circle = range,\n      newPos = {\n        x: range.position.x - this.canvasSize.width,\n        y: range.position.y - this.canvasSize.height\n      };\n    if (circle.radius !== undefined) {\n      const biggerCircle = new _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.Circle(newPos.x, newPos.y, circle.radius * double);\n      return super.intersects(biggerCircle);\n    } else if (rect.size !== undefined) {\n      const rectSW = new _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.Rectangle(newPos.x, newPos.y, rect.size.width * double, rect.size.height * double);\n      return super.intersects(rectSW);\n    }\n    return false;\n  }\n}\n\n//# sourceURL=webpack://@tsparticles/interaction-particles-links/./dist/browser/CircleWarp.js?\n}");

/***/ }),

/***/ "./dist/browser/LinkInstance.js":
/*!**************************************!*\
  !*** ./dist/browser/LinkInstance.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   LinkInstance: () => (/* binding */ LinkInstance)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"@tsparticles/engine\");\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _Utils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Utils.js */ \"./dist/browser/Utils.js\");\n\n\nconst minOpacity = 0,\n  minWidth = 0,\n  minDistance = 0,\n  half = 0.5,\n  maxFrequency = 1;\nclass LinkInstance {\n  constructor(container, engine) {\n    this._drawLinkLine = (p1, link) => {\n      const p1LinksOptions = p1.options.links;\n      if (!p1LinksOptions?.enable) {\n        return;\n      }\n      const container = this._container,\n        options = container.actualOptions,\n        p2 = link.destination,\n        pos1 = p1.getPosition(),\n        pos2 = p2.getPosition();\n      let opacity = link.opacity;\n      container.canvas.draw(ctx => {\n        let colorLine;\n        const twinkle = p1.options.twinkle?.lines;\n        if (twinkle?.enable) {\n          const twinkleFreq = twinkle.frequency,\n            twinkleRgb = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.rangeColorToRgb)(this._engine, twinkle.color),\n            twinkling = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRandom)() < twinkleFreq;\n          if (twinkling && twinkleRgb) {\n            colorLine = twinkleRgb;\n            opacity = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRangeValue)(twinkle.opacity);\n          }\n        }\n        if (!colorLine) {\n          const linkColor = p1LinksOptions.id !== undefined ? container.particles.linksColors.get(p1LinksOptions.id) : container.particles.linksColor;\n          colorLine = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getLinkColor)(p1, p2, linkColor);\n        }\n        if (!colorLine) {\n          return;\n        }\n        const width = p1.retina.linksWidth ?? minWidth,\n          maxDistance = p1.retina.linksDistance ?? minDistance,\n          {\n            backgroundMask\n          } = options;\n        (0,_Utils_js__WEBPACK_IMPORTED_MODULE_1__.drawLinkLine)({\n          context: ctx,\n          width,\n          begin: pos1,\n          end: pos2,\n          engine: this._engine,\n          maxDistance,\n          canvasSize: container.canvas.size,\n          links: p1LinksOptions,\n          backgroundMask: backgroundMask,\n          colorLine,\n          opacity\n        });\n      });\n    };\n    this._drawLinkTriangle = (p1, link1, link2) => {\n      const linksOptions = p1.options.links;\n      if (!linksOptions?.enable) {\n        return;\n      }\n      const triangleOptions = linksOptions.triangles;\n      if (!triangleOptions.enable) {\n        return;\n      }\n      const container = this._container,\n        options = container.actualOptions,\n        p2 = link1.destination,\n        p3 = link2.destination,\n        opacityTriangle = triangleOptions.opacity ?? (link1.opacity + link2.opacity) * half;\n      if (opacityTriangle <= minOpacity) {\n        return;\n      }\n      container.canvas.draw(ctx => {\n        const pos1 = p1.getPosition(),\n          pos2 = p2.getPosition(),\n          pos3 = p3.getPosition(),\n          linksDistance = p1.retina.linksDistance ?? minDistance;\n        if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getDistance)(pos1, pos2) > linksDistance || (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getDistance)(pos3, pos2) > linksDistance || (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getDistance)(pos3, pos1) > linksDistance) {\n          return;\n        }\n        let colorTriangle = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.rangeColorToRgb)(this._engine, triangleOptions.color);\n        if (!colorTriangle) {\n          const linkColor = linksOptions.id !== undefined ? container.particles.linksColors.get(linksOptions.id) : container.particles.linksColor;\n          colorTriangle = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getLinkColor)(p1, p2, linkColor);\n        }\n        if (!colorTriangle) {\n          return;\n        }\n        (0,_Utils_js__WEBPACK_IMPORTED_MODULE_1__.drawLinkTriangle)({\n          context: ctx,\n          pos1,\n          pos2,\n          pos3,\n          backgroundMask: options.backgroundMask,\n          colorTriangle,\n          opacityTriangle\n        });\n      });\n    };\n    this._drawTriangles = (options, p1, link, p1Links) => {\n      const p2 = link.destination;\n      if (!(options.links?.triangles.enable && p2.options.links?.triangles.enable)) {\n        return;\n      }\n      const vertices = p2.links?.filter(t => {\n        const linkFreq = this._getLinkFrequency(p2, t.destination),\n          minCount = 0;\n        return p2.options.links && linkFreq <= p2.options.links.frequency && p1Links.findIndex(l => l.destination === t.destination) >= minCount;\n      });\n      if (!vertices?.length) {\n        return;\n      }\n      for (const vertex of vertices) {\n        const p3 = vertex.destination,\n          triangleFreq = this._getTriangleFrequency(p1, p2, p3);\n        if (triangleFreq > options.links.triangles.frequency) {\n          continue;\n        }\n        this._drawLinkTriangle(p1, link, vertex);\n      }\n    };\n    this._getLinkFrequency = (p1, p2) => {\n      return (0,_Utils_js__WEBPACK_IMPORTED_MODULE_1__.setLinkFrequency)([p1, p2], this._freqs.links);\n    };\n    this._getTriangleFrequency = (p1, p2, p3) => {\n      return (0,_Utils_js__WEBPACK_IMPORTED_MODULE_1__.setLinkFrequency)([p1, p2, p3], this._freqs.triangles);\n    };\n    this._container = container;\n    this._engine = engine;\n    this._freqs = {\n      links: new Map(),\n      triangles: new Map()\n    };\n  }\n  drawParticle(context, particle) {\n    const {\n      links,\n      options\n    } = particle;\n    if (!links?.length) {\n      return;\n    }\n    const p1Links = links.filter(l => options.links && (options.links.frequency >= maxFrequency || this._getLinkFrequency(particle, l.destination) <= options.links.frequency));\n    for (const link of p1Links) {\n      this._drawTriangles(options, particle, link, p1Links);\n      if (link.opacity > minOpacity && (particle.retina.linksWidth ?? minWidth) > minWidth) {\n        this._drawLinkLine(particle, link);\n      }\n    }\n  }\n  async init() {\n    this._freqs.links = new Map();\n    this._freqs.triangles = new Map();\n    await Promise.resolve();\n  }\n  particleCreated(particle) {\n    particle.links = [];\n    if (!particle.options.links) {\n      return;\n    }\n    const ratio = this._container.retina.pixelRatio,\n      {\n        retina\n      } = particle,\n      {\n        distance,\n        width\n      } = particle.options.links;\n    retina.linksDistance = distance * ratio;\n    retina.linksWidth = width * ratio;\n  }\n  particleDestroyed(particle) {\n    particle.links = [];\n  }\n}\n\n//# sourceURL=webpack://@tsparticles/interaction-particles-links/./dist/browser/LinkInstance.js?\n}");

/***/ }),

/***/ "./dist/browser/Linker.js":
/*!********************************!*\
  !*** ./dist/browser/Linker.js ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Linker: () => (/* binding */ Linker)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"@tsparticles/engine\");\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _CircleWarp_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./CircleWarp.js */ \"./dist/browser/CircleWarp.js\");\n/* harmony import */ var _Options_Classes_Links_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Options/Classes/Links.js */ \"./dist/browser/Options/Classes/Links.js\");\n\n\n\nconst squarePower = 2,\n  opacityOffset = 1,\n  origin = {\n    x: 0,\n    y: 0\n  },\n  minDistance = 0;\nfunction getLinkDistance(pos1, pos2, optDistance, canvasSize, warp) {\n  const {\n    dx,\n    dy,\n    distance\n  } = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getDistances)(pos1, pos2);\n  if (!warp || distance <= optDistance) {\n    return distance;\n  }\n  const absDiffs = {\n      x: Math.abs(dx),\n      y: Math.abs(dy)\n    },\n    warpDistances = {\n      x: Math.min(absDiffs.x, canvasSize.width - absDiffs.x),\n      y: Math.min(absDiffs.y, canvasSize.height - absDiffs.y)\n    };\n  return Math.sqrt(warpDistances.x ** squarePower + warpDistances.y ** squarePower);\n}\nclass Linker extends _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.ParticlesInteractorBase {\n  constructor(container, engine) {\n    super(container);\n    this._setColor = p1 => {\n      if (!p1.options.links) {\n        return;\n      }\n      const container = this._linkContainer,\n        linksOptions = p1.options.links;\n      let linkColor = linksOptions.id === undefined ? container.particles.linksColor : container.particles.linksColors.get(linksOptions.id);\n      if (linkColor) {\n        return;\n      }\n      const optColor = linksOptions.color;\n      linkColor = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getLinkRandomColor)(this._engine, optColor, linksOptions.blink, linksOptions.consent);\n      if (linksOptions.id === undefined) {\n        container.particles.linksColor = linkColor;\n      } else {\n        container.particles.linksColors.set(linksOptions.id, linkColor);\n      }\n    };\n    this._linkContainer = container;\n    this._engine = engine;\n  }\n  clear() {}\n  init() {\n    this._linkContainer.particles.linksColor = undefined;\n    this._linkContainer.particles.linksColors = new Map();\n  }\n  interact(p1) {\n    if (!p1.options.links) {\n      return;\n    }\n    p1.links = [];\n    const pos1 = p1.getPosition(),\n      container = this.container,\n      canvasSize = container.canvas.size;\n    if (pos1.x < origin.x || pos1.y < origin.y || pos1.x > canvasSize.width || pos1.y > canvasSize.height) {\n      return;\n    }\n    const linkOpt1 = p1.options.links,\n      optOpacity = linkOpt1.opacity,\n      optDistance = p1.retina.linksDistance ?? minDistance,\n      warp = linkOpt1.warp;\n    let range;\n    if (warp) {\n      range = new _CircleWarp_js__WEBPACK_IMPORTED_MODULE_1__.CircleWarp(pos1.x, pos1.y, optDistance, canvasSize);\n    } else {\n      range = new _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.Circle(pos1.x, pos1.y, optDistance);\n    }\n    const query = container.particles.quadTree.query(range);\n    for (const p2 of query) {\n      const linkOpt2 = p2.options.links;\n      if (p1 === p2 || !linkOpt2?.enable || linkOpt1.id !== linkOpt2.id || p2.spawning || p2.destroyed || !p2.links || p1.links.some(t => t.destination === p2) || p2.links.some(t => t.destination === p1)) {\n        continue;\n      }\n      const pos2 = p2.getPosition();\n      if (pos2.x < origin.x || pos2.y < origin.y || pos2.x > canvasSize.width || pos2.y > canvasSize.height) {\n        continue;\n      }\n      const distance = getLinkDistance(pos1, pos2, optDistance, canvasSize, warp && linkOpt2.warp);\n      if (distance > optDistance) {\n        continue;\n      }\n      const opacityLine = (opacityOffset - distance / optDistance) * optOpacity;\n      this._setColor(p1);\n      p1.links.push({\n        destination: p2,\n        opacity: opacityLine\n      });\n    }\n  }\n  isEnabled(particle) {\n    return !!particle.options.links?.enable;\n  }\n  loadParticlesOptions(options, ...sources) {\n    if (!options.links) {\n      options.links = new _Options_Classes_Links_js__WEBPACK_IMPORTED_MODULE_2__.Links();\n    }\n    for (const source of sources) {\n      options.links.load(source?.links);\n    }\n  }\n  reset() {}\n}\n\n//# sourceURL=webpack://@tsparticles/interaction-particles-links/./dist/browser/Linker.js?\n}");

/***/ }),

/***/ "./dist/browser/LinksPlugin.js":
/*!*************************************!*\
  !*** ./dist/browser/LinksPlugin.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   LinksPlugin: () => (/* binding */ LinksPlugin)\n/* harmony export */ });\n/* harmony import */ var _LinkInstance_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./LinkInstance.js */ \"./dist/browser/LinkInstance.js\");\n\nclass LinksPlugin {\n  constructor(engine) {\n    this.id = \"links\";\n    this._engine = engine;\n  }\n  getPlugin(container) {\n    return Promise.resolve(new _LinkInstance_js__WEBPACK_IMPORTED_MODULE_0__.LinkInstance(container, this._engine));\n  }\n  loadOptions() {}\n  needsPlugin() {\n    return true;\n  }\n}\n\n//# sourceURL=webpack://@tsparticles/interaction-particles-links/./dist/browser/LinksPlugin.js?\n}");

/***/ }),

/***/ "./dist/browser/Options/Classes/Links.js":
/*!***********************************************!*\
  !*** ./dist/browser/Options/Classes/Links.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Links: () => (/* binding */ Links)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"@tsparticles/engine\");\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _LinksShadow_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./LinksShadow.js */ \"./dist/browser/Options/Classes/LinksShadow.js\");\n/* harmony import */ var _LinksTriangle_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./LinksTriangle.js */ \"./dist/browser/Options/Classes/LinksTriangle.js\");\n\n\n\nclass Links {\n  constructor() {\n    this.blink = false;\n    this.color = new _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OptionsColor();\n    this.color.value = \"#fff\";\n    this.consent = false;\n    this.distance = 100;\n    this.enable = false;\n    this.frequency = 1;\n    this.opacity = 1;\n    this.shadow = new _LinksShadow_js__WEBPACK_IMPORTED_MODULE_1__.LinksShadow();\n    this.triangles = new _LinksTriangle_js__WEBPACK_IMPORTED_MODULE_2__.LinksTriangle();\n    this.width = 1;\n    this.warp = false;\n  }\n  load(data) {\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (data.id !== undefined) {\n      this.id = data.id;\n    }\n    if (data.blink !== undefined) {\n      this.blink = data.blink;\n    }\n    this.color = _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OptionsColor.create(this.color, data.color);\n    if (data.consent !== undefined) {\n      this.consent = data.consent;\n    }\n    if (data.distance !== undefined) {\n      this.distance = data.distance;\n    }\n    if (data.enable !== undefined) {\n      this.enable = data.enable;\n    }\n    if (data.frequency !== undefined) {\n      this.frequency = data.frequency;\n    }\n    if (data.opacity !== undefined) {\n      this.opacity = data.opacity;\n    }\n    this.shadow.load(data.shadow);\n    this.triangles.load(data.triangles);\n    if (data.width !== undefined) {\n      this.width = data.width;\n    }\n    if (data.warp !== undefined) {\n      this.warp = data.warp;\n    }\n  }\n}\n\n//# sourceURL=webpack://@tsparticles/interaction-particles-links/./dist/browser/Options/Classes/Links.js?\n}");

/***/ }),

/***/ "./dist/browser/Options/Classes/LinksShadow.js":
/*!*****************************************************!*\
  !*** ./dist/browser/Options/Classes/LinksShadow.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   LinksShadow: () => (/* binding */ LinksShadow)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"@tsparticles/engine\");\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__);\n\nclass LinksShadow {\n  constructor() {\n    this.blur = 5;\n    this.color = new _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OptionsColor();\n    this.color.value = \"#000\";\n    this.enable = false;\n  }\n  load(data) {\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (data.blur !== undefined) {\n      this.blur = data.blur;\n    }\n    this.color = _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OptionsColor.create(this.color, data.color);\n    if (data.enable !== undefined) {\n      this.enable = data.enable;\n    }\n  }\n}\n\n//# sourceURL=webpack://@tsparticles/interaction-particles-links/./dist/browser/Options/Classes/LinksShadow.js?\n}");

/***/ }),

/***/ "./dist/browser/Options/Classes/LinksTriangle.js":
/*!*******************************************************!*\
  !*** ./dist/browser/Options/Classes/LinksTriangle.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   LinksTriangle: () => (/* binding */ LinksTriangle)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"@tsparticles/engine\");\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__);\n\nclass LinksTriangle {\n  constructor() {\n    this.enable = false;\n    this.frequency = 1;\n  }\n  load(data) {\n    if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.isNull)(data)) {\n      return;\n    }\n    if (data.color !== undefined) {\n      this.color = _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.OptionsColor.create(this.color, data.color);\n    }\n    if (data.enable !== undefined) {\n      this.enable = data.enable;\n    }\n    if (data.frequency !== undefined) {\n      this.frequency = data.frequency;\n    }\n    if (data.opacity !== undefined) {\n      this.opacity = data.opacity;\n    }\n  }\n}\n\n//# sourceURL=webpack://@tsparticles/interaction-particles-links/./dist/browser/Options/Classes/LinksTriangle.js?\n}");

/***/ }),

/***/ "./dist/browser/Utils.js":
/*!*******************************!*\
  !*** ./dist/browser/Utils.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   drawLinkLine: () => (/* binding */ drawLinkLine),\n/* harmony export */   drawLinkTriangle: () => (/* binding */ drawLinkTriangle),\n/* harmony export */   drawTriangle: () => (/* binding */ drawTriangle),\n/* harmony export */   getLinkKey: () => (/* binding */ getLinkKey),\n/* harmony export */   setLinkFrequency: () => (/* binding */ setLinkFrequency)\n/* harmony export */ });\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tsparticles/engine */ \"@tsparticles/engine\");\n/* harmony import */ var _tsparticles_engine__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__);\n\nfunction drawTriangle(context, p1, p2, p3) {\n  context.beginPath();\n  context.moveTo(p1.x, p1.y);\n  context.lineTo(p2.x, p2.y);\n  context.lineTo(p3.x, p3.y);\n  context.closePath();\n}\nfunction drawLinkLine(params) {\n  let drawn = false;\n  const {\n    begin,\n    end,\n    engine,\n    maxDistance,\n    context,\n    canvasSize,\n    width,\n    backgroundMask,\n    colorLine,\n    opacity,\n    links\n  } = params;\n  if ((0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getDistance)(begin, end) <= maxDistance) {\n    (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.drawLine)(context, begin, end);\n    drawn = true;\n  } else if (links.warp) {\n    let pi1;\n    let pi2;\n    const endNE = {\n      x: end.x - canvasSize.width,\n      y: end.y\n    };\n    const d1 = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getDistances)(begin, endNE);\n    if (d1.distance <= maxDistance) {\n      const yi = begin.y - d1.dy / d1.dx * begin.x;\n      pi1 = {\n        x: 0,\n        y: yi\n      };\n      pi2 = {\n        x: canvasSize.width,\n        y: yi\n      };\n    } else {\n      const endSW = {\n        x: end.x,\n        y: end.y - canvasSize.height\n      };\n      const d2 = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getDistances)(begin, endSW);\n      if (d2.distance <= maxDistance) {\n        const yi = begin.y - d2.dy / d2.dx * begin.x;\n        const xi = -yi / (d2.dy / d2.dx);\n        pi1 = {\n          x: xi,\n          y: 0\n        };\n        pi2 = {\n          x: xi,\n          y: canvasSize.height\n        };\n      } else {\n        const endSE = {\n          x: end.x - canvasSize.width,\n          y: end.y - canvasSize.height\n        };\n        const d3 = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getDistances)(begin, endSE);\n        if (d3.distance <= maxDistance) {\n          const yi = begin.y - d3.dy / d3.dx * begin.x;\n          const xi = -yi / (d3.dy / d3.dx);\n          pi1 = {\n            x: xi,\n            y: yi\n          };\n          pi2 = {\n            x: pi1.x + canvasSize.width,\n            y: pi1.y + canvasSize.height\n          };\n        }\n      }\n    }\n    if (pi1 && pi2) {\n      (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.drawLine)(context, begin, pi1);\n      (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.drawLine)(context, end, pi2);\n      drawn = true;\n    }\n  }\n  if (!drawn) {\n    return;\n  }\n  context.lineWidth = width;\n  if (backgroundMask.enable) {\n    context.globalCompositeOperation = backgroundMask.composite;\n  }\n  context.strokeStyle = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getStyleFromRgb)(colorLine, opacity);\n  const {\n    shadow\n  } = links;\n  if (shadow.enable) {\n    const shadowColor = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.rangeColorToRgb)(engine, shadow.color);\n    if (shadowColor) {\n      context.shadowBlur = shadow.blur;\n      context.shadowColor = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getStyleFromRgb)(shadowColor);\n    }\n  }\n  context.stroke();\n}\nfunction drawLinkTriangle(params) {\n  const {\n    context,\n    pos1,\n    pos2,\n    pos3,\n    backgroundMask,\n    colorTriangle,\n    opacityTriangle\n  } = params;\n  drawTriangle(context, pos1, pos2, pos3);\n  if (backgroundMask.enable) {\n    context.globalCompositeOperation = backgroundMask.composite;\n  }\n  context.fillStyle = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getStyleFromRgb)(colorTriangle, opacityTriangle);\n  context.fill();\n}\nfunction getLinkKey(ids) {\n  ids.sort((a, b) => a - b);\n  return ids.join(\"_\");\n}\nfunction setLinkFrequency(particles, dictionary) {\n  const key = getLinkKey(particles.map(t => t.id));\n  let res = dictionary.get(key);\n  if (res === undefined) {\n    res = (0,_tsparticles_engine__WEBPACK_IMPORTED_MODULE_0__.getRandom)();\n    dictionary.set(key, res);\n  }\n  return res;\n}\n\n//# sourceURL=webpack://@tsparticles/interaction-particles-links/./dist/browser/Utils.js?\n}");

/***/ }),

/***/ "./dist/browser/index.js":
/*!*******************************!*\
  !*** ./dist/browser/index.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Links: () => (/* reexport safe */ _Options_Classes_Links_js__WEBPACK_IMPORTED_MODULE_2__.Links),\n/* harmony export */   LinksShadow: () => (/* reexport safe */ _Options_Classes_LinksShadow_js__WEBPACK_IMPORTED_MODULE_3__.LinksShadow),\n/* harmony export */   LinksTriangle: () => (/* reexport safe */ _Options_Classes_LinksTriangle_js__WEBPACK_IMPORTED_MODULE_4__.LinksTriangle),\n/* harmony export */   loadParticlesLinksInteraction: () => (/* binding */ loadParticlesLinksInteraction)\n/* harmony export */ });\n/* harmony import */ var _interaction_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./interaction.js */ \"./dist/browser/interaction.js\");\n/* harmony import */ var _plugin_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./plugin.js */ \"./dist/browser/plugin.js\");\n/* harmony import */ var _Options_Classes_Links_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Options/Classes/Links.js */ \"./dist/browser/Options/Classes/Links.js\");\n/* harmony import */ var _Options_Classes_LinksShadow_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Options/Classes/LinksShadow.js */ \"./dist/browser/Options/Classes/LinksShadow.js\");\n/* harmony import */ var _Options_Classes_LinksTriangle_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Options/Classes/LinksTriangle.js */ \"./dist/browser/Options/Classes/LinksTriangle.js\");\n\n\nasync function loadParticlesLinksInteraction(engine, refresh = true) {\n  engine.checkVersion(\"3.9.1\");\n  await (0,_interaction_js__WEBPACK_IMPORTED_MODULE_0__.loadLinksInteraction)(engine, refresh);\n  await (0,_plugin_js__WEBPACK_IMPORTED_MODULE_1__.loadLinksPlugin)(engine, refresh);\n}\n\n\n\n\n\n\n\n//# sourceURL=webpack://@tsparticles/interaction-particles-links/./dist/browser/index.js?\n}");

/***/ }),

/***/ "./dist/browser/interaction.js":
/*!*************************************!*\
  !*** ./dist/browser/interaction.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   loadLinksInteraction: () => (/* binding */ loadLinksInteraction)\n/* harmony export */ });\n/* harmony import */ var _Linker_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Linker.js */ \"./dist/browser/Linker.js\");\n\nasync function loadLinksInteraction(engine, refresh = true) {\n  await engine.addInteractor(\"particlesLinks\", async container => {\n    return Promise.resolve(new _Linker_js__WEBPACK_IMPORTED_MODULE_0__.Linker(container, engine));\n  }, refresh);\n}\n\n//# sourceURL=webpack://@tsparticles/interaction-particles-links/./dist/browser/interaction.js?\n}");

/***/ }),

/***/ "./dist/browser/plugin.js":
/*!********************************!*\
  !*** ./dist/browser/plugin.js ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   loadLinksPlugin: () => (/* binding */ loadLinksPlugin)\n/* harmony export */ });\n/* harmony import */ var _LinksPlugin_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./LinksPlugin.js */ \"./dist/browser/LinksPlugin.js\");\n\nasync function loadLinksPlugin(engine, refresh = true) {\n  const plugin = new _LinksPlugin_js__WEBPACK_IMPORTED_MODULE_0__.LinksPlugin(engine);\n  await engine.addPlugin(plugin, refresh);\n}\n\n//# sourceURL=webpack://@tsparticles/interaction-particles-links/./dist/browser/plugin.js?\n}");

/***/ }),

/***/ "@tsparticles/engine":
/*!*********************************************************************************************************************************!*\
  !*** external {"commonjs":"@tsparticles/engine","commonjs2":"@tsparticles/engine","amd":"@tsparticles/engine","root":"window"} ***!
  \*********************************************************************************************************************************/
/***/ ((module) => {

module.exports = __WEBPACK_EXTERNAL_MODULE__tsparticles_engine__;

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module can't be inlined because the eval devtool is used.
/******/ 	var __webpack_exports__ = __webpack_require__("./dist/browser/index.js");
/******/ 	
/******/ 	return __webpack_exports__;
/******/ })()
;
});