<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSuppliersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Schema::dropIfExists('suppliers');

        Schema::create('suppliers', function (Blueprint $table) {
            $table->id(); // Supplier's unique ID
            $table->string('name'); // Supplier's name
            $table->string('contact_person'); // Name of the contact person at the supplier
            $table->string('phone_number'); // Contact phone number
            $table->string('email')->nullable(); // Supplier's email address
            $table->string('address'); // Supplier's physical address
            $table->date('join_date'); 
            $table->decimal('total_money', 10, 2)->default(0); // Total money supplier is owed
            $table->decimal('received_money', 10, 2)->default(0); // Total money already paid to supplier
            $table->decimal('remaining_money', 10, 2)->default(0); // Remaining money supplier is owed
            $table->foreignId('company_id')->constrained('companies')->onDelete('cascade');
            $table->timestamps(); // Created and updated timestamps
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('suppliers');
    }
}
