<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProductsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id(); 
            $table->string('product_image')->nullable();
            $table->string('name');
            $table->decimal('purchase_price', 10, 2); 
            $table->decimal('sales_price', 10, 2);
            $table->integer('quantity'); 
            $table->date('manufacturing_date'); 
            $table->date('expiration_date')->nullable(); 
            $table->string('barcode')->unique();
            $table->unsignedBigInteger('category_id');
            $table->unsignedBigInteger('medicine_type_id');
            $table->unsignedBigInteger('company_id');
            $table->timestamps(); 

            $table->foreign('category_id')->references('id')->on('categories')->onDelete('cascade');
            $table->foreign('medicine_type_id')->references('id')->on('medicine_types')->onDelete('cascade');
            $table->foreign('company_id')->references('id')->on('companies')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('products');
    }
}

