<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SaleItem extends Model
{
    use HasFactory;

    protected $fillable = [
        'company_id',
        'sale_id',
        'product_name',
        'sales_price',
        'quantity',
        'total_price',
        'paid_amount',
        'is_fully_paid',
        'profit',
        'sale_date',
    ];

    protected $casts = [
        'sale_date' => 'datetime'
    ];

    public function sale()
    {
        return $this->belongsTo(Sale::class);
    }
}
