<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Sale extends Model
{
    use HasFactory;

    protected $fillable = [
        'customer_name',
        'phone_number',
        'customer_type',
        'email',
        'address',
        'partial_customer_id',
        'sale_date',
        'total_amount',
        'amount_paid',
        'products',
        'company_id',
    ];

    protected $casts = [
        'products' => 'array',
    ];


    public function saleItems()
    {
        return $this->hasMany(SaleItem::class);
    }

    public function products()
    {
        return $this->belongsToMany(Product::class);
    }

    
    public function payments()
    {
        return $this->hasMany(SalePayment::class);
    }
}
