<?php

namespace App\Models;

use Illuminate\Foundation\Auth\User as Authenticatable; // Use Laravel's built-in Authenticatable model
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;


class Company extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $fillable = ['name', 'email', 'password', 'role', 'is_locked'];

    protected $casts = [
        'is_locked' => 'boolean',
    ];
    
    public function users()
    {
        return $this->hasMany(CompanyUser::class);
    }

    // In Company model
    public function categories()
    {
        return $this->hasMany(Category::class);
    }

    public function profile()
    {
        return $this->hasOne(CompanyProfile::class, 'company_id');
    }

    public function product()
    {
        return $this->hasMany(Product::class);
    }

    public function saleItem()
    {
        return $this->hasMany(SaleItem::class);
    }


}


