<?php

namespace App\Http\Middleware;

   use Closure;
   use Illuminate\Http\Request;
   use Symfony\Component\HttpFoundation\Response;

   class EnsureUserHasRole
   {
       /**
        * Handle an incoming request.
        *
        * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
        */
       public function handle(Request $request, Closure $next, ...$role): Response
       {
           // Check if the authenticated user has the required role
           $user = auth('admin')->user() ?? auth('user')->user();

           if(!$user){
                return redirect()->route('userdashboard')->with('error', 'You are not authorized to access this page.');
           }

           if(!in_array($user->role, $role)){
                return redirect()->route('userdashboard')->with('error', 'You are not authorized to access this page.');
           }

           return $next($request);

        //    if ($request->user() && $request->user()->role === $role) {
        //        return $next($request);
        //    }

        //    // Redirect or abort if the user doesn't have the required role
        //    return redirect()->route('userdashboard')->with('error', 'You are not authorized to access this page.');
       }
   }

