<?php

namespace App\Http\Controllers;

use App\Models\Stock;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use App\Models\Purchase;
use App\Models\SystemSetting;

class StockController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        //
        
        $companyId = getCompanyId();
        $query = Stock::where('company_id', $companyId)
                    ->orderBy('created_at', 'desc');

        if ($request->has('search') && !empty($request->search)) {
            $search = $request->search;
            $query->where('product_name', 'like', '%' . $search . '%');
        }
        $stocks = $query->paginate(8);

        $stocks->transform(function ($item) {
            $item->hashed_id = substr(md5($item->id), 0, 8);

            $companyId = getCompanyId();
            $settings = SystemSetting::where('company_id', $companyId)->first();
            $settings_stock_amount = $settings->stock_amount_status;

            $item->stock_amount = $item->quantity ?? 0;
            $quantity = $item->quantity ?? 0;

            // Log::info(['quantities:'=>$quantity]);

            if($quantity == 0){
                $status = 'Out of Stock';
            }elseif($quantity < $settings_stock_amount){
                $status = 'Low Stock';
            }else{
                $status = 'High Stock';
            }
            $item->stock_status = $status;
        Log::info(['items:'=>$item]);

            return $item;

        });


        return response()->json($stocks);
    }


    //-====================== fetch data in sale
    public function getStockData()
    {
        //
        $companyId = getCompanyId();
        $stocks = Stock::where('company_id', $companyId)
                    ->orderBy('created_at', 'desc')
                    ->get();
        return response()->json($stocks);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }


    //=======================
    
    public function countstockedProducts()
    {
        try {
            $companyId = null;

            // Determine if the request is from an admin or a user
            $companyId = getCompanyId();

            // Calculate the count of all products
            $stockedCount = Stock::where('company_id', $companyId)->count();

 
            return response()->json(['stocked_products_count' => $stockedCount], 200);
        } catch (\Exception $e) {
            return response()->json(['error' => 'Internal Server Error'], 500);
        }
    }

    //=========================

    public function updateStock(Request $request) 
    { 
        $products = $request->input('products'); 
        foreach ($products as $product) 
        { 
            $stock = Stock::where('product_name', $product['product_name'])->first(); 
            if ($stock) 
            { 
                $stock->quantity -= $product['quantity']; 

               $quantity = $stock->quantity;

                if($quantity == 0){
                    $status = 'Out of Stock';
                }elseif($quantity < 10){
                    $status = 'Low Stock';
                }else{
                    $status = 'High stock';
                }

                $stock->status = $status;
                $stock->save(); 
            } 
        } 
        
        return response()->json(['message' => 'Stock updated successfully']); 
    }


    //==================

    public function searchDrug(Request $request){

        $query = Stock::query();

        if($request->has('search') && $request->search !== ''){
            $query->where('product_name', 'like', '%' . $request->search . '%');
        }

        $stocks = $query->with('companyProfile')->get();

        return response()->json($stocks);
    }


    //=================

    public function getDrugDetails($id){
        $drug = Stock::with('companyProfile')->find($id);

        // Log::info(['Drug details:'=> $drug]);
        if(!$drug){
            return response()->json(['message'=>'drug not found'], 404);
        }
        return response()->json($drug);
    }


    //=================================

    public function getLowStocks()
    {
        $companyId = getCompanyId();
        $lowStock = Stock::where('company_id', $companyId)
        ->where('quantity' , '<', 10)
        ->count();

        return response()->json(['low_stock_count' => $lowStock]);
    }

    public function getHighStocks()
    {
        $companyId = getCompanyId();
        $highStock = Stock::where('company_id', $companyId)
        ->where('quantity' , '>', 9)
        ->count();

        return response()->json(['high_stock_count' => $highStock]);
    }



    //================= History

    public function history($id)
    {

        Log::info(['id:'=> $id]);


        $purchases = Purchase::with('supplier')
            ->where('product_id', $id)
            ->orderBy('purchase_date', 'desc')
            ->get();
           
        Log::info(['purchases with supplier:'=> $purchases]);
        
        return response()->json($purchases);
    }
}
