<?php

namespace App\Http\Controllers;

use App\Http\Requests\ProfileUpdateRequest;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Redirect;
use Inertia\Inertia;
use Inertia\Response;

class ProfileController extends Controller
{
    /**
     * Display the user's profile form.
     */
    public function edit(Request $request): Response
    {
        // Check for the authenticated user across different guards
        $user = Auth::guard('web')->user() ?? Auth::guard('admin')->user() ?? Auth::guard('user')->user();

        // Pass the `user` to the view with Inertia
        return Inertia::render('Profile/Edit', [
            'mustVerifyEmail' => $user instanceof MustVerifyEmail,
            'status' => session('status'),
            'user' => $user,
            'userRole' => auth()->user()->role,
        ]);
        
    }
    

    /**
     * Update the user's profile information.
     */
    public function update(ProfileUpdateRequest $request): RedirectResponse
    {
        // Retrieve the correct user based on the active guard
        $user = null;
        if (Auth::guard('web')->check()) {
            $user = \App\Models\User::find(Auth::guard('web')->id());
        } elseif (Auth::guard('admin')->check()) {
            $user = \App\Models\Company::find(Auth::guard('admin')->id());
        } elseif (Auth::guard('user')->check()) {
            $user = \App\Models\CompanyUser::find(Auth::guard('user')->id());
        }
    
        if ($user) {
            $user->fill($request->validated());
    
            // if ($user->isDirty('email')) {
            //     $user->email_verified_at = null;
            // }
    
            $user->save();
        }
    
        return Redirect::route('profile.edit');
    }
    
    public function destroy(Request $request): RedirectResponse
    {
        // Retrieve the correct user based on the active guard
        $user = null;
        if (Auth::guard('web')->check()) {
            $user = \App\Models\User::find(Auth::guard('web')->id());
        } elseif (Auth::guard('admin')->check()) {
            $user = \App\Models\Company::find(Auth::guard('admin')->id());
        } elseif (Auth::guard('user')->check()) {
            $user = \App\Models\CompanyUser::find(Auth::guard('user')->id());
        }
    
        if ($user) {
            // Log out from all guards
            Auth::guard('web')->logout();
            Auth::guard('admin')->logout();
            Auth::guard('user')->logout();
    
            $user->delete();
    
            $request->session()->invalidate();
            $request->session()->regenerateToken();
        }
    
        return Redirect::to('/');
    }
    
    
}
