<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\Log;
use App\Models\Expense;
use Illuminate\Http\Request;
use Nette\Schema\Expect;

class ExpenseController extends Controller
{
    public function index(Request $request)
    {
        $companyId = getCompanyId();
        $query = Expense::where('company_id', $companyId)
                        ->orderBy('created_at', 'desc');
 
        // Add search functionality
        if ($request->has('search') && !empty($request->search)) {
            $search = $request->search;
            $query->where('expense_type', 'like', '%' . $search . '%');
        }
 
        // Paginate the results
        $expenses = $query->paginate(6);
 
        return response()->json($expenses);
    }

    public function store(Request $request)
    {
        $companyId = getCompanyId();

        Log::info('Welcome dear');

        $validated = $request->validate([
            'amount' => 'required|numeric',
            'expense_type' => 'required|string',
            'description' => 'nullable|string',
            'date' => 'required|date',
        ]);


        $expense = Expense::create([
            'amount' => $validated['amount'],
            'expense_type' => $validated['expense_type'],
            'description' => $validated['description'],
            'date' => $validated['date'],
            'company_id' => $companyId,
        ]);

        return response()->json(['expense' => $expense], 201);
    }

    public function update(Request $request, $id)
    {
        $companyId = getCompanyId();

        $expense = Expense::where('id', $id)->where('company_id', $companyId)->firstOrFail();
        $validated = $request->validate([
            'amount' => 'required|numeric',
            'expense_type' => 'required|string',
            'description' => 'nullable|string',
            'date' => 'required|date',
        ]);

        $expense->update($validated);

        return response()->json($expense);
    }

    public function destroy($id)
    {
        $companyId = getCompanyId();

        $expense = Expense::where('id', $id)->where('company_id', $companyId)->firstOrFail();

        $expense->delete();

        return response()->json(['message' => 'Expense deleted successfully']);
    }
}
