<?php
// debug.php - Place this in public folder
require __DIR__ . '/vendor/autoload.php';

$app = require_once __DIR__ . '/bootstrap/app.php';

$kernel = $app->make(Illuminate\Contracts\Http\Kernel::class);

$response = $kernel->handle(
    $request = Illuminate\Http\Request::capture()
);

// Try to simulate login request
$_POST['email'] = 'test@test.com';
$_POST['password'] = 'test';
$_SERVER['REQUEST_METHOD'] = 'POST';
$_SERVER['REQUEST_URI'] = '/login';

try {
    // Try to connect to database
    echo "<h2>Database Test:</h2>";
    $pdo = new PDO('mysql:host=localhost;dbname=' . $_ENV['DB_DATABASE'], 
                   $_ENV['DB_USERNAME'], 
                   $_ENV['DB_PASSWORD']);
    echo "✓ Database connected<br>";
    
    // Test Laravel auth
    echo "<h2>Laravel Test:</h2>";
    $user = \App\Models\User::first();
    echo "✓ Users table accessible<br>";
    
} catch (Exception $e) {
    echo "<h2>Error:</h2>";
    echo "<pre>";
    echo "Message: " . $e->getMessage() . "\n\n";
    echo "File: " . $e->getFile() . ":" . $e->getLine() . "\n\n";
    echo "Trace:\n" . $e->getTraceAsString();
    echo "</pre>";
}