 document.addEventListener("DOMContentLoaded", () => {
        const slides = document.querySelectorAll(".slide");
        const nextBtn = document.getElementById("next-slide");
        const prevBtn = document.getElementById("prev-slide");
        const paginationContainer = document.getElementById("pagination");
        const sliderContainer = document.getElementById("slider-container");
        let currentIndex = 0;
        let autoPlayInterval;

        //  dots
        slides.forEach((_, i) => {
          const dot = document.createElement("div");
          dot.classList.add("pagination-dot");
          dot.dataset.index = i;
          if (i === 0) dot.dataset.active = true;
          paginationContainer.appendChild(dot);
        });

        const dots = document.querySelectorAll(".pagination-dot");

        function showSlide(index) {
          if (index >= slides.length) {
            index = 0;
          } else if (index < 0) {
            index = slides.length - 1;
          }

          slides.forEach((slide) => delete slide.dataset.active);
          dots.forEach((dot) => delete dot.dataset.active);

          slides[index].dataset.active = true;
          dots[index].dataset.active = true;

          currentIndex = index;
        }

        function nextSlide() {
          showSlide(currentIndex + 1);
        }

        function prevSlide() {
          showSlide(currentIndex - 1);
        }

        function startAutoPlay() {
          autoPlayInterval = setInterval(nextSlide, 9000); // change 5 seconds
        }

        function stopAutoPlay() {
          clearInterval(autoPlayInterval);
        }

        nextBtn.addEventListener("click", nextSlide);
        prevBtn.addEventListener("click", prevSlide);

        dots.forEach((dot) => {
          dot.addEventListener("click", () => {
            showSlide(parseInt(dot.dataset.index));
          });
        });

        sliderContainer.addEventListener("mouseenter", stopAutoPlay);
        sliderContainer.addEventListener("mouseleave", startAutoPlay);

        [nextBtn, prevBtn, ...dots].forEach((el) => {
          el.addEventListener("click", () => {
            stopAutoPlay();
            startAutoPlay();
          });
        });

        showSlide(0);
        startAutoPlay();
      });